%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% VELOCIDADES CORRESPONDIENTES A LOS AMIGOS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% Input:
%%%%%%%%% p = posicion del agente
%%%%%%%%% v = velocidad del agente
%%%%%%%%% pA = posicion de los amigos cercanos al agente
%%%%%%%%% vA = velocidad de los amigos cercanos al agente
%%%%%%%%% Output: velocidadN = nueva velocidad del agente
function velocidadN = adaptaAgenteAmigos(posicion, velocidad, posicionA, velocidadA, vMax, opcionesAmigos, r) 
[nAgentes, nCoordenadas] = size(posicion);
velocidadN = zeros(nAgentes, nCoordenadas);

if opcionesAmigos.vAlineacion == 1,
    velocidadN = velocidadN + calculaAlineacion(posicion, posicionA, velocidad, velocidadA, vMax, r);
end
if opcionesAmigos.vCohesion == 1,
    velocidadN = velocidadN + calculaCohesion(posicion, posicionA, vMax, r);
end
if opcionesAmigos.vBusqueda == 1,
    velocidadN = velocidadN + calculaBusquedaMultiple(posicion, posicionA, vMax);
end