%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% VELOCIDADES CORRESPONDIENTES A LOS ENEMIGOS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% Input:
%%%%%%%%% posicion = posicion del agente
%%%%%%%%% velocidad = velocidad del agente
%%%%%%%%% posicionE = posicion de los enemigos cercanos al agente
%%%%%%%%% velocidadE = velocidad de los enemigos cercanos al agente
%%%%%%%%% Output: velocidadN = nueva velocidad del agente
function velocidadN = adaptaAgenteEnemigos(posicion, velocidad, posicionE, velocidadE, vMax, opcionesEnemigos, r)
[nAgentes, nCoordenadas] = size(posicion);
velocidadN = zeros(nAgentes, nCoordenadas);

if opcionesEnemigos.vAlineacion == 1,
    velocidadN = velocidadN - calculaAlineacion(posicion, posicionE, velocidad, velocidadE, vMax, r);
end
if opcionesEnemigos.vSeparacion == 1,
    velocidadN = velocidadN + calculaSeparacion(posicion, posicionE, vMax, r);
end
if opcionesEnemigos.vHuida == 1,
    velocidadN = velocidadN + calculaHuidaMultiple(posicion, posicionE, vMax);
end