%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% VELOCIDAD CORRESPONDIENTES A LAS METAS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% Input:
%%%%%%%%% posicion = posicion del agente
%%%%%%%%% mCercana = meta mas cercana
%%%%%%%%% Output: velocidadN = nueva velocidad del agente
function velocidadN = adaptaAgenteMetas(posicion, mCercana, parametrosVelocidad, parametrosMetas)
velocidadN = 0;

nCoordenadas = size(posicion, 2);
%%%%%%%%% Influye solo la meta mas cercana
pMeta = parametrosMetas.posicion;
wMeta = parametrosMetas.peso;
nMetas = parametrosMetas.nMetas;
if parametrosVelocidad.vMasCercana == 1,
    velocidadN = velocidadN + calculaMeta(posicion, pMeta(mCercana, :), wMeta(mCercana));
%%%%%%%%% Influyen todas las metas    
else     
    vMeta = zeros(nMetas, nCoordenadas);
    for j = 1:nMetas,
        vMeta(j, :) = calculaMeta(posicion, pMeta(j, :), wMeta(j));
    end
    velocidadN = velocidadN + mean(vMeta, 1);
end