%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% VELOCIDAD CORRESPONDIENTES A LA ZONA DE INFLUENCIA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
%%%%%%%%% Input:
%%%%%%%%% posicion = posicion del agente
%%%%%%%%% velocidad = velocidad del agente
%%%%%%%%% Si se encuentra en una zona de influencia de meta:
%%%%%%%%%    posicionEnemigosM = posicion de los agentes enemigos en la meta
%%%%%%%%%    posicionOtrosM  = posicion de agentes no enemigos en la meta
%%%%%%%%% Output: velocidadN = nueva velocidad del agente
function velocidadN = adaptaAgenteZonaInfluencia(posicion, velocidad, posicionEnemigosM, posicionOtrosM, parametrosMetas)
velocidadN = 0;

%%%%%%%%% VELOCIDAD CORRESPONDIENTE A LA ZONA DE INFLUENCIA
%%%%%%%%% Si se encuentra en la zona de influencia de la meta y si hay mas
%%%%%%%%% agentes en esa zona se cohesiona (con los agentes no enemigos) y 
%%%%%%%%% huye de los agentes enemigos que se encuentran en la zona de
%%%%%%%%% influencia de la meta.
if parametrosMetas.vInfluencia == 1,
    if isempty(posicionOtrosM) == 0,
        velocidadN = velocidadN + calculaCohesion(posicion, posicionOtrosM, parametrosMetas.pInfluencia);
    end
    if isempty(posicionEnemigosM) == 0,
        velocidadN = velocidadN + calculaHuida(posicion, posicionEnemigosM, velocidad, parametrosMetas.pInfluencia);
    end
end