function [vAmigos, atacantes, atacados, metasAtacadas] = ataqueAmigos(posicion, enemigos, amigos, radioVision, atacantes, atacados, posicionObjetivo)
[nAgentes, nCoordenadas] = size(posicion);
estado = zeros(nAgentes, 1);
for i = 1:nAgentes,
    if estado(i) == 0,
        amigosAgente = detectaAmigos(i, posicion, radioVision, amigos{i});
        if isempty(amigosAgentes) == 0,
            if (ismember(i, atacantes) == 1),
                cuadrilla = tienenEnemigoComun(atacados(i), amigosAgente, enemigos);
                nElementos = length(cuadrilla);
                if nElementos > 0,
                    posicionObjetivo(cuadrilla, :) = posicionObjetivo(i, :);
                    for i = 1:nElementos,
                        atacante = cuadrilla(i);
                        vAmigos(atacante, :) = calculaBusquedaSimple(posicion(atacante, :), posicionObjetivo(atacante, :), vMax);
                    end
                    estado(cuadrilla) = 1;
                end
                estado(i) = 1;
            end
            vAmigos(i, :) = calculaAmigos(posicion(i, :), posicion(amigosAgentes, :), parametrosAmigos, vMax);
        end
    end
end