function [vAtaque, atacantes, atacados, metasAtacadas, metasDestino] = ataqueExterno(posicion, posicionMetas, enMeta, ...
    enemigos, nivelDesesperacion, limiteDesesperacion, maximaNorma)
[nAgentes, nCoordenadas] = size(posicion);
nMetas = size(posicionMetas, 1);

atacados = []; atacantes = []; metasAtacadas = []; metasDestino = [];
vAtaque = zeros(nAgentes, nCoordenadas);

posiblesAtacantes = find(nivelDesesperacion >= limiteDesesperacion);
fuera = find(enMeta(posiblesAtacantes) == 0);
posiblesAtacantes = posiblesAtacantes(fuera);
nAtacantes = length(posiblesAtacantes);
for i = 1:nAtacantes,
    atacante = posiblesAtacantes(i);
    [agentesAtacados, metaAtacada] = hayAtaqueExterno(nMetas, atacante, enemigos{atacante}, enMeta);
    nAtaques = length(agentesAtacados);
    if nAtaques > 0,
        cadena = mat2str(agentesAtacados);
        %fprintf('Se realiza ataque externo de %d(%d) a %s en la meta %d\n', atacante, ...
        %    nivelDesesperacion(atacante), cadena, metaAtacada);
        for j = 1:nAtaques,
            atacado = agentesAtacados(j);
            vAtaque(atacado, :) = calculaHuidaSimple(posicion(atacado, :), posicionMetas(metaAtacada, :), maximaNorma);
        end
        vAtaque(atacante, :) = calculaBusquedaSimple(posicion(atacante, :), posicionMetas(metaAtacada, :), maximaNorma);
        atacantes = [atacantes; atacante]; atacados = [atacados agentesAtacados];
        metasDestino = [metasDestino metaAtacada];
    end
end
if isempty(atacados) == 0,
    metasAtacadas = enMeta(atacados);
end