function [vAtaque, atacantes, atacados, metasAtacadas] = ataqueInterno(posicion, posicionMetas, enMeta, vecinos, nivelD, maximaNorma)
[nAgentes, nCoordenadas] = size(posicion);
vAtaque = zeros(nAgentes, nCoordenadas);
nMetas = size(posicionMetas, 1);
atacantes = []; atacados = []; metasAtacadas = [];
for i = 1:nMetas,
    idx = find(enMeta == i);
    nidx = length(idx);
    if nidx > 1,
        [atacantesM, atacadosM] = hayAtaqueInterno(idx, vecinos, nivelD);
        nAtaques = length(atacantesM);
        for j = 1:nAtaques,
            atacante = atacantesM{j}; 
            agentesAtacados = atacadosM{j};
            cadena = mat2str(agentesAtacados);
            %fprintf('Se realiza ataque interno de %d a %s en la meta %d\n', atacante, cadena, i);
            nAtacados = length(agentesAtacados);
            for k = 1:nAtacados,
                atacado = agentesAtacados(k);
                vAtaque(atacado, :) = calculaHuidaSimple(posicion(atacado, :), posicionMetas(i, :), maximaNorma);
            end
            atacantes = [atacantes; atacante];
            atacados = [atacados agentesAtacados];
        end
    end
end
if isempty(atacados) == 0,
    metasAtacadas = enMeta(atacados);
end