function [estado, vAmigos] = calculaAmigos(posicion, velocidad, enMeta, enemigos, amigos,...
    opcionesAmigos, zonaPrivada, radioVision, vMax)
[nAgentes, nCoordenadas] = size(posicion);
vAmigos   = zeros(nAgentes, nCoordenadas);
estado = zeros(nAgentes, 1);
for i = 1:nAgentes,
    amigosAgente = detectaAmigos(i, posicion, radioVision, amigos{i});
    if ismember(i, atacantes) == 1,
    
        if isempty(amigosAgente) == 0,
            nAmigosAgente = length(amigosAgente);
            cuadrilla = [];
            for j = 1:nAmigosAgente,
                amigo = amigosAgente(j);
                enemigosComunes = intersect(enemigos{i}, enemigos{amigo});
                enemigoEnMeta = find(enMeta(enemigosComunes));
                if isempty(enemigoEnMeta) == 0,
                    cuadrilla = [cuadrilla amigo];
                end
            end
            nCuadrilla = length(cuadrilla);
            if nCuadrilla > 0,
                estado(i) = 2;
                estado(cuadrilla) = 2;
                 vAmigos(i, :) = adaptaAgenteAmigos(posicion(i, :), velocidad(i, :), ...
                        posicion(cuadrilla, :), velocidad(cuadrilla, :), vMax, opcionesAmigos, zonaPrivada);
                vAmigos(cuadrilla, :) = repmat(vAmigos(i, :), nCuadrilla, 1);
            end
        end
    end
end

% if isempty(enemigosAgente) == 0,
%         estado(i) = 1;
%         vEnemigos(i, :) = adaptaAgenteEnemigos(posicion(i, :), velocidad(i, :), ...
%             posicion(enemigosAgente, :), velocidad(enemigosAgente, :), vMax, opcionesEnemigos, zonaPrivada);
% end
