function [velocidadNueva, nivelDesesperacion] = calculaAtaque(estadoSistema, velocidadNueva, enMeta, datosPrograma)
enemigos = estadoSistema.vecinos;
posicion = estadoSistema.posicion;
velocidad = estadoSistema.velocidad;
nivelDesesperacion = estadoSistema.nivelDesesperacion;

limiteDesesperacion = datosPrograma.parametrosAgentes.limiteDesesperacion;
posicionMeta = datosPrograma.parametrosMetas.posicion;
pesoAtaque   = datosPrograma.parametrosVelocidad.pAtaque;

%%%%%%%%%%%%%%%%%%%%%% Mira a ver quienes estan en metas
%%%%%%%%%%%%%%%%%%%%%% porque si no hay nadie en meta, no hay ataque
dentro = dentroMeta(enMeta);
if isempty(dentro) == 0,
    %%%%%% Mirar a ver quienes estan desesperados
    idx = find(nivelDesesperacion == limiteDesesperacion);
    nidx = length(idx);
    for i = 1:nidx,
        %%%%%%%%%% Al ataque uno de ellos
        atacante = idx(i);
        %%%%%%%%%% Mira a ver que enemigos tiene en las metas
        %%%%%%%%%% Si encuentra una meta con enemigos, ataca a todos los
        %%%%%%%%%% enemigos que se encuentren en esa meta
        [metaAtacada, enemigosAtacados] = eligeMetaParaAtacar(enemigos{atacante}, enMeta);
        if isempty(enemigosAtacados) == 0,
            nEnemigos = length(enemigosAtacados);
            nAtaques = 0;
            for j = 1:nEnemigos,
                %%%%%%%%%% El pobrecillo enemigo
                enemigoAtacado = enemigosAtacados(j);
                %%%%%%%%%% Si el nivel de estres del atacante es mayor que
                %%%%%%%%%% el nivel de estres de atacado (no vale ahora
                %%%%%%%%%% para nada????)
                if nivelDesesperacion(enemigoAtacado) < nivelDesesperacion(atacante),
                    %%%%%% Ataca provocandole una huida de la meta
                    vAtaque = calculaHuida(posicion(enemigoAtacado, :), posicionMeta(metaAtacada, :), ...
                        velocidad(enemigoAtacado, :), pesoAtaque);
                    velocidadNueva(enemigoAtacado, :) = velocidadNueva(enemigoAtacado, :) + vAtaque;
                    %%%%%% Y el avanza un poco hacia la meta
                    vMeta = calculaMeta(posicion(atacante, :), posicionMeta(metaAtacada, :), pesoAtaque);
                    velocidadNueva(atacante, :) = velocidadNueva(atacante, :) + vMeta;
                    %%%%%% Ha habido ataque con exito
                    nAtaques = nAtaques + 1;
                    %%%%%% Se quita el estres en uno por el ataque realizado
                    nivelDesesperacion(atacante) = nivelDesesperacion(atacante) - 1;
                end
            end
        else
            nAtaques = 0;
        end
        fprintf('Ha habido ataques de %d a %d enemigos en la meta %d\n', atacante, nAtaques, metaAtacada);
    end
end