function vCohesion = calculaCohesion(posicion, posicionVecinos, vMax, r)
[nVecinos, nCoordenadas] = size(posicionVecinos);
vCohesion = zeros(1, nCoordenadas);
if nVecinos > 0,
    deltaPos = mean(posicionVecinos, 1) - posicion;
    [deltaPosN, normaDeltaPos] = normalizaVector(deltaPos);
    factor = (normaDeltaPos/r).^2;
    vCohesion = factor .* vMax .* deltaPosN;
end