function orientacion = calculaOrientacion(velocidad, aceleracion)
v = cross(velocidad, aceleracion);
direccionLateral = normalizaVector(cross(v, velocidad));
magnitudLateral = dot(direccionLateral, aceleracion);

if (abs(magnitudLateral) < 1.0e-6)
    roll = 0;
else
    roll = -atan2 (9.806650, magnitudLateral) + (pi/2);
end
pitch = -atan2 (velocidad(2), sqrt(velocidad(1)*velocidad(1) + velocidad(3)*velocidad(3)));
yaw   = atan2 (velocidad(1), velocidad(3));
orientacion = [roll pitch yaw];
