function vSeparacion = calculaSeparacion(posicion, posicionVecinos, vMax, r)
[nVecinos, nCoordenadas] = size(posicionVecinos);
vSeparacion = zeros(1, nCoordenadas);
if nVecinos > 0,
    deltaPos = mean(posicionVecinos, 1) - posicion;
    [deltaPosN, normaDeltaPos] = normalizaVector(deltaPos);
    if normaDeltaPos > eps,
        factor = (r/normaDeltaPos).^2;
        vSeparacion = - factor .* vMax .* deltaPosN;
    else
        vSeparacion(:) = vMax;
    end
end