function [colores, nColoreados, nCorrectos] = coloreaGrafo(nMetas, enMeta, vecinos)
nAgentes = size(enMeta, 1);
colores = zeros(nAgentes, 1);
coloreados = find(enMeta > 0);
colores(coloreados) = enMeta(coloreados);
nColoreados = length(coloreados);

nCorrectos = 0;
for i = 1:nMetas,
    agentesEnMeta = find(colores == i);
    nAgentesEnMeta = length(agentesEnMeta);
    if nAgentesEnMeta > 0,
        if length(agentesEnMeta) == 1,
            nCorrectos = nCorrectos + 1;
        else
            conjuntoUnion = generaConjuntoUnion(agentesEnMeta, vecinos);
            agentesEnConflicto = intersect(agentesEnMeta, conjuntoUnion);
            nAgentesEnConflicto = length(agentesEnConflicto);
            noConflicto = nAgentesEnMeta - nAgentesEnConflicto;
            nCorrectos = nCorrectos + noConflicto;
        end
    end
end