function experimento = coloreadoFase(datosPrograma, estadoSistema, nIteraciones, traza, cadena)
nAgentes = estadoSistema.nAgentes;

posicionMetas = datosPrograma.parametrosMetas.posicion;
nMetas = size(posicionMetas, 1);

nColoreadosTotal = zeros(nIteraciones, 1);
nCorrectosTotal  = zeros(nIteraciones, 1);
nAtaquesInternosTotal = zeros(nIteraciones, nMetas);
nAtaquesExternosTotal = zeros(nIteraciones, nMetas);
densidadMetaTotal = zeros(nIteraciones, nMetas);
nColoreados = 0; nCorrectos = 0;
for k = 1:nIteraciones,
    [estadoSistema, colores, nColoreados, nCorrectos, nAtaques, densidadMeta] = ejecutaUnPaso(estadoSistema, datosPrograma);
    if traza == 1,
        fprintf ('nIteraciones %d  nColoreados %d  nCorrectos %d\n', k, nColoreados, nCorrectos);
    end
    nColoreadosTotal(k) = nColoreados;
    nCorrectosTotal(k) = nCorrectos;
    nAtaquesInternosTotal(k, :) = nAtaques.internos;
    nAtaquesExternosTotal(k, :) = nAtaques.externos;
    densidadMetaTotal(k, :) = densidadMeta;
    if nCorrectos == nAgentes,
        break;
    end
end
fprintf ('*** Final %s: nIteraciones %d  nColoreados %d  nCorrectos %d\n', cadena, k, nColoreados, nCorrectos);
experimento = [];
experimento.coloreado = colores; 
experimento.nColoreados = nColoreadosTotal(1:k);
experimento.nCorrectos  = nCorrectosTotal(1:k);
experimento.nAtaques.internos = nAtaquesInternosTotal(1:k, :);
experimento.nAtaques.externos = nAtaquesExternosTotal(1:k, :);
experimento.densidadMeta = densidadMetaTotal(1:k, :);
experimento.nIteraciones = k;
experimento.estadoSistema = estadoSistema;