function experimento = coloreadoSinInterfaz(datosPrograma, estadoSistema, nIteraciones)
nAgentes = estadoSistema.nAgentes;
%nMetas   = datosPrograma.parametrosMetas.nMetas;

mundo = datosPrograma.mundo;
posicionMetas = datosPrograma.parametrosMetas.posicion;
nMetas = size(posicionMetas, 1);
radioInfluencia = datosPrograma.parametrosMetas.rInfluencia;
color = datosPrograma.parametrosMetas.color;
zonaPrivada = datosPrograma.parametrosAgentes.zonaPrivada;

dibujaMetas(mundo, posicionMetas, radioInfluencia, color);
h_agentes = dibujaAgentes(estadoSistema.posicion, zonaPrivada);
h_vector = dibujaVector(estadoSistema.posicion, estadoSistema.velocidad);

nColoreadosTotal = zeros(nIteraciones, 1);
nCorrectosTotal  = zeros(nIteraciones, 1);
nAtaquesInternosTotal = zeros(nIteraciones, nMetas);
nAtaquesExternosTotal = zeros(nIteraciones, nMetas);
densidadMetaTotal = zeros(nIteraciones, nMetas);
for k = 1:nIteraciones,
    [estadoSistema, colores, nColoreados, nCorrectos, nAtaques, densidadMeta] = ejecutaUnPaso(estadoSistema, datosPrograma);
    h_agentes = reDibujaAgentes(h_agentes, mundo, estadoSistema.posicion);
    h_vector  = reDibujaVector(h_vector, estadoSistema.posicion, estadoSistema.velocidad);
    fprintf ('nIteraciones %d  nColoreados %d  nCorrectos %d\n', k, nColoreados, nCorrectos);
    nColoreadosTotal(k) = nColoreados;
    nCorrectosTotal(k) = nCorrectos;
    nAtaquesInternosTotal(k, :) = nAtaques.internos;
    nAtaquesExternosTotal(k, :) = nAtaques.externos;
    densidadMetaTotal(k, :) = densidadMeta;
    if nCorrectos == nAgentes,
        break;
    end
end
experimento = [];
experimento.coloreado = colores; 
experimento.nColoreados = nColoreadosTotal;
experimento.nCorrectos  = nCorrectosTotal;
experimento.nAtaques.internos = nAtaquesInternosTotal;
experimento.nAtaques.externos = nAtaquesExternosTotal;
experimento.densidadMeta = densidadMeta;
experimento.nIteraciones = k;