function varargout = coloreado_Interfaz(varargin)
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @coloreado_Interfaz_OpeningFcn, ...
                   'gui_OutputFcn',  @coloreado_Interfaz_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

function coloreado_Interfaz_OpeningFcn(hObject, eventdata, handles, varargin)
directorioS = 'Results'; %%%% directorio de los resultados (.mat y .txt)
if isdir(directorioS) == 0,
    mkdir(directorioS);
end

cdActual = pwd;
arbol_cd = genpath(cdActual);
addpath(arbol_cd);

datosPrograma = Estrategia_3colores();

setCadena('nombreFichero', '');
setCadena('nAgentes', 0);
setCadena('visorIteraciones', 0);
setCadena('visorColoreado', 0);
xmin = datosPrograma.mundo.xmin;
xmax = datosPrograma.mundo.xmax;
ymin = datosPrograma.mundo.ymin;
ymax = datosPrograma.mundo.ymax;
setCadena('xmin', xmin);
setCadena('xmax', xmax);
setCadena('ymin', ymin);
setCadena('ymax', ymax);

inicializaFigura(datosPrograma.mundo);

handles.output = hObject;
handles.UserData.cdBase = cdActual;
handles.UserData.datosPrograma = datosPrograma;
handles.UserData.nIteraciones = 5000;
handles.pRun = 0;

guidata(hObject, handles);

function varargout = coloreado_Interfaz_OutputFcn(hObject, eventdata, handles) 
varargout{1} = handles.output;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% X MINIMO 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xmin_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function xmin_Callback(hObject, eventdata, handles)
xmin = str2double(get(hObject, 'String'));
mundo = handles.UserData.datosPrograma.mundo;
handles.UserData.datosPrograma.mundo = inicializaMundo2D(xmin, mundo.xmax, mundo.ymin, mundo.ymax);
guidata(hObject, handles);
redimensionaFigura(handles.UserData.datosPrograma.mundo);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% X MAXIMO 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xmax_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function xmax_Callback(hObject, eventdata, handles)
xmax = str2double(get(hObject, 'String'));
mundo = handles.UserData.datosPrograma.mundo;
handles.UserData.datosPrograma.mundo = inicializaMundo2D(mundo.xmin, xmax, mundo.ymin, mundo.ymax);
guidata(hObject, handles);
redimensionaFigura(handles.UserData.datosPrograma.mundo);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Y MINIMO 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ymin_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function ymin_Callback(hObject, eventdata, handles)
ymin = str2double(get(hObject, 'String'));
mundo = handles.UserData.datosPrograma.mundo;
handles.UserData.datosPrograma.mundo = inicializaMundo2D(mundo.xmin, mundo.xmax, ymin, mundo.ymax);
guidata(hObject, handles);
redimensionaFigura(handles.UserData.datosPrograma.mundo);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% Y MAXIMO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ymax_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function ymax_Callback(hObject, eventdata, handles)
ymax = str2double(get(hObject, 'String'));
mundo = handles.UserData.datosPrograma.mundo;
handles.UserData.datosPrograma.mundo = inicializaMundo2D(mundo.xmin, mundo.xmax, mundo.ymin, ymax);
guidata(hObject, handles);
redimensionaFigura(handles.UserData.datosPrograma.mundo);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% NOMBRE
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function nombreFichero_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function BuscaFichero_Callback(hObject, eventdata, handles)
cd(handles.UserData.cdBase);
directorioL = 'Graphs';  %%%% directorio de los datos (grafos)
cd(directorioL);
nombreFichero = uigetfile('*.txt','Choose the Graph');
cd ..;
setCadena('nombreFichero', nombreFichero);
datosPrograma = handles.UserData.datosPrograma;
datosPrograma = inicializaExperimento(nombreFichero, datosPrograma);
nAgentes = length(datosPrograma.nAgentes);
setCadena('nAgentes', nAgentes);
setCadena('visorIteraciones', 0);
setCadena('visorColoreado', 0);
estadoSistema = inicializaSistema(datosPrograma);
handles.UserData.nombreFichero = nombreFichero;
handles.UserData.datosPrograma = datosPrograma;
handles.UserData.estadoSistema = estadoSistema;
guidata(hObject, handles);

function nombreFichero_Callback(hObject, eventdata, handles)
nombreFichero = get(hObject, 'String');
setCadena('nombreFichero', nombreFichero);
datosPrograma = handles.UserData.datosPrograma;
datosPrograma = inicializaExperimento(nombreFichero, datosPrograma);
nAgentes = length(datosPrograma.nAgentes);
setCadena('nAgentes', nAgentes);
setCadena('visorIteraciones', 0);
setCadena('visorColoreado', 0);
estadoSistema = inicializaSistema(datosPrograma);
handles.UserData.nombreFichero = nombreFichero;
handles.UserData.datosPrograma = datosPrograma;
handles.UserData.estadoSistema = estadoSistema;
guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% PARAMETROS VELOCIDAD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function parVelocidad_Callback(hObject, eventdata, handles)
datosPrograma = handles.UserData.datosPrograma;
[f, nuevosParametros] = interfazVelocidad(datosPrograma);
if strcmp(f, 'OK'),
    disp('OK velocidad');
    handles.UserData.datosPrograma = nuevosParametros;
    guidata(hObject, handles);
end
%%%% fprintf('Nuevos parametros de Velocidad : \n');
%%%% IMPRIMIR VALORES VELOCIDAD

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% PARAMETROS METAS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function parMetas_Callback(hObject, eventdata, handles)
parametrosMetas = handles.UserData.datosPrograma.parametrosMetas;
[f, nuevosParametros] = interfazMetas(parametrosMetas);
if strcmp(f, 'OK'),
    disp('OK metas');
    handles.UserData.datosPrograma.parametrosMetas = nuevosParametros;
    guidata(hObject, handles);
end
%%%% fprintf('Nuevos parametros de Metas : \n');
%%%% IMPRIMIR VALORES METAS

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% COMENZAR
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function pStart_Callback(hObject, eventdata, handles)
set(handles.pRun, 'UserData', 1);
guidata(hObject, handles);

datosPrograma = handles.UserData.datosPrograma;
estadoSistema = handles.UserData.estadoSistema;
nIteraciones = handles.UserData.nIteraciones;
experimento = [];
tic;
experimento = coloreadoFase_Interfaz(datosPrograma, estadoSistema, nIteraciones, handles);
t = toc;
nombreFichero = handles.UserData.nombreFichero;
[nombreF, r] = strtok(nombreFichero, '.');
nombreFicheroS = strcat(nombreF, '_3colorsS');
escribeInforme(nombreFicheroS, experimento, 'Results', t, handles.UserData.cdBase);
handles.experimento = experimento;
guidata(hObject, handles);

function [experimento, flag] = coloreadoFase_Interfaz(datosPrograma, estadoSistema, nIteraciones, handles)
nAgentes = estadoSistema.nAgentes;

posicionMetas = datosPrograma.parametrosMetas.posicion;
nMetas = size(posicionMetas, 1);

nColoreadosTotal = zeros(nIteraciones, 1);
nCorrectosTotal  = zeros(nIteraciones, 1);
nAtaquesInternosTotal = zeros(nIteraciones, nMetas);
nAtaquesExternosTotal = zeros(nIteraciones, nMetas);
densidadMetaTotal = zeros(nIteraciones, nMetas);

mundo = datosPrograma.mundo;
posicionMetas = datosPrograma.parametrosMetas.posicion;
radioInfluencia = datosPrograma.parametrosMetas.rInfluencia;
color = datosPrograma.parametrosMetas.color;
zonaPrivada = datosPrograma.parametrosAgentes.zonaPrivada;

dibujaMetas(mundo, posicionMetas, radioInfluencia, color);
h_agentes = dibujaAgentes(estadoSistema.posicion, zonaPrivada);
h_vector = dibujaVector(estadoSistema.posicion, estadoSistema.velocidad);
k = 1;
continua = get(handles.pRun, 'UserData');
flag = 0;
while continua == 1,
    setCadena('visorIteraciones', k);

    [estadoSistema, colores, nColoreados, nCorrectos, nAtaques, densidadMeta] = ejecutaUnPaso(estadoSistema, datosPrograma);

    h_agentes = reDibujaAgentes(h_agentes, mundo, estadoSistema.posicion);
    h_vector  = reDibujaVector(h_vector, estadoSistema.posicion, estadoSistema.velocidad);

    nColoreadosTotal(k) = nColoreados;
    nCorrectosTotal(k) = nCorrectos;
    nAtaquesInternosTotal(k, :) = nAtaques.internos;
    nAtaquesExternosTotal(k, :) = nAtaques.externos;
    densidadMetaTotal(k, :) = densidadMeta;
    
    setCadena('visorColoreado', nColoreados);
    setCadena('visorCorrectos', nCorrectos);

    if nCorrectos == nAgentes,
        break;
    end
    if k == nIteraciones,
        break;
    end

    k = k + 1;
    continua = get(handles.pRun, 'UserData');
end
experimento = [];
if k > 1,
    experimento.coloreado = colores; 
    experimento.nColoreados = nColoreadosTotal(1:k);
    experimento.nCorrectos  = nCorrectosTotal(1:k);
    experimento.nAtaques.internos = nAtaquesInternosTotal(1:k, :);
    experimento.nAtaques.externos = nAtaquesExternosTotal(1:k, :);
    experimento.densidadMeta = densidadMetaTotal(1:k, :);
    experimento.nIteraciones = k;
    experimento.estadoSistema = estadoSistema;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% CONTINUAR / PARAR
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function pStop_Callback(hObject, eventdata, handles)
set(handles.pRun, 'UserData', 0);
guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% INICIALIZACION DEL SISTEMA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function estadoSistema = inicializaSistema(datosPrograma)
mundo = datosPrograma.mundo;
nAgentes = datosPrograma.nAgentes;
nCoordenadas = mundo.nCoordenadas;
posicion = puntosEnMundo(nAgentes, mundo);
velocidad = vectorAleatorio(nAgentes, [-1 -1], [1 1]);
estadoSistema.nAgentes = nAgentes;
estadoSistema.nCoordenadas = nCoordenadas;
estadoSistema.posicion = posicion;
estadoSistema.velocidad = velocidad;
estadoSistema.nivelDesesperacion = zeros(nAgentes, 1);
tipoHorizonte = datosPrograma.tipoHorizonte;
posicionMetas = datosPrograma.parametrosMetas.posicion;
estadoSistema.posicionObjetivo = inicializaObjetivos(mundo, tipoHorizonte, posicion, posicionMetas);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%% OTRAS FUNCIONES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function h = buscaObjeto(nombre)
h = findobj('Tag', nombre);

function setValor(nombre, valor)
h = buscaObjeto(nombre);
set(h, 'Value', valor);

function setCadena(nombre, valor)
h = buscaObjeto(nombre);
set(h, 'String', num2str(valor));


%%%%%%%%%%%%% Limpia pantalla de dibujo e inicializa los limites del mundo
function inicializaFigura(mundo)
h_figura = buscaObjeto('figura_mundo');
cla(h_figura);
set(h_figura, 'XLim', [mundo.xmin mundo.xmax], 'YLim', [mundo.ymin mundo.ymax]);
axis off;

%%%%%%%%%%%%% Cambia los limites del mundo
function redimensionaFigura(mundo)
h_figura = buscaObjeto('figura_mundo');
set(h_figura, 'XLim', [mundo.xmin mundo.xmax], 'YLim', [mundo.ymin mundo.ymax]);
axes(h_figura);
axis off;

%%%%%%%%%%%%% Dibuja las Metas
function dibujaMetas2D(parametrosMetas, mundo)
h_figura = buscaObjeto('figura_mundo');
cla(h_figura);
set(h_figura, 'XLim', [mundo.xmin mundo.xmax], 'YLim', [mundo.ymin mundo.ymax]);
axis off;
nMetas = parametrosMetas.nMetas;
hold on;
for i = 1:nMetas,
    x = parametrosMetas.posicion(i, 1); y = parametrosMetas.posicion(i, 2);
    r = parametrosMetas.radioInfluencia; c = parametrosMetas.color{i};
    dibujaCirculo(x, y, r, c);
end
drawnow;

%%%%%%%%%%%%% Dibuja Agentes
function h = dibujaAgentes(posicion, zonaPrivada)
nAgentes = size(posicion, 1);
h = [];
for i = 1:nAgentes,
    h{i} = plot(posicion(i, 1), posicion(i, 2), 'oy');
    set(h{i}, 'MarkerSize', zonaPrivada, 'EraseMode', 'xor');
end
drawnow;

function h = reDibujaAgentes(h, mundo, posicion)
nAgentes = size(posicion, 1);
for i = 1:nAgentes,
    set(h{i}, 'X', posicion(i, 1), 'Y', posicion(i, 2));
end
%set(gca, 'Xlim', [mundo.xmin mundo.xmax], 'Ylim', [mundo.ymin mundo.ymax]);
drawnow;

%%%%%%%%%%%%%%%% Informe del proceso
function escribeInforme(nombreFichero, experimento, directorio, tEjecucion, cdBase)
cd(cdBase);
cd(directorio); %%%% directorio de los resultados (.mat y .txt)
save(nombreFichero, 'experimento');
nombreFicheroS = strcat(nombreFichero, '.txt');
fi = fopen(nombreFicheroS, 'w');
fprintf(fi, '***** Coloreado Simple %s\n', nombreFichero);
fprintf(fi, '*** Tpo. Ejecucion : %s\n', num2str(tEjecucion));
fprintf(fi, '***************************************************\n');
if isempty(experimento) == 0,
    nIteraciones = experimento.nIteraciones;
    nColoreados  = experimento.nColoreados(nIteraciones);
    nCorrectos   = experimento.nCorrectos(nIteraciones);
    fprintf(fi, '      Coloreado 3colores: nColoreados %d   nCorrectos %d    nIteraciones %d\n', ...
            nColoreados, nCorrectos, nIteraciones);
end
cd ..;