function linea = creaLinea(varargin)
if length(varargin) == 1,

	%%%%% Un parametro de entrada (angulo de la linea o array de cuatro parametros)
    	var = varargin{1};
    
    	if size(var, 2) == 4,
        	%%%% array de cuatro parametros
        	linea = var;
    	elseif size(var, 2)==1
        	%%%% angulo de la linea desde el origen de coordenadas
        	linea = [zeros(size(var)) zeros(size(var)) cos(var) sin(var)];
    	else
        	error('Numero erroneo para un parametro de entrada: angulo o cuatro parametros');
    	end
    
elseif length(varargin) == 2,
	
	%%%% Dos parametros de entrada (angulo de la linea y distancia al origen o dos puntos)  
	v1 = varargin{1};
      v2 = varargin{2};
    	if size(v1, 2) == 1,
		%%%% angulo de la linea y distancia al origen
        	linea = [v1.*cos(v2) v1.*sin(v2) -sin(v2) cos(v2)];
   	else
		%%%% dos puntos
        	linea = [v1(:, 1), v1(:, 2), v2(:, 1)-v1(:, 1), v2(:, 2)-v1(:, 2)];    
    	end
    
elseif length(varargin) == 3,

	%%%% Tres parametros de entrada (un punto de la linea (vector p) y vectores directores de la linea: dx y dy)
	p = varargin{1};
	linea = [p(:, 1) p(:,2) varargin{2} varargin{3}];
   
elseif length(varargin) == 4,

	%%%% Cuatro parametros de entrada (un punto de la linea (x0, y0) y dos vectores directores de la linea: dx y dy)
	linea = [varargin{1} varargin{2} varargin{3} varargin{4}];
else
    error('Numero erroreo de argumentos');
end
