%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%% Demostracion del Coloreado en Cascada sin interfaz
%%%%%%%%% 1. fase: Coloreado con 4 colores (nIteraciones Final : 1500)
%%%%%%%%% 2. fase: Coloreado con 3 colores (nIteraciones Final : 3500)
%%%%%%%%% Datos de Entrada: Directorio Graphs
%%%%%%%%% Datos de Salida : Directorio Results

%%%%%%%%% Cada experimento se repite tantas veces como nInstancias 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%% Elimina todas las variables temporales
clear all;

%%%%%% Nombre de los ficheros de grafos que existen en el directorio
%%%%%% "Graphs"
directorioL = 'Graphs';  %%%% directorio de los datos (grafos)
cd(directorioL);
nombres = dir('*.txt');
cd ..;
directorioS = 'Results'; %%%% directorio de los resultados (.mat y .txt)
if isdir(directorioS) == 0,
    mkdir(directorioS);
end

%%%%%% Adaptacion del path de Matlab
cd_actual = pwd;
arbol_cd = genpath(cd_actual);
addpath(arbol_cd);

nFicheros = length(nombres);
nIteraciones4 = 1500; %%%% nIteraciones de la Fase de 4 colores
nIteraciones3 = 3500; %%%% nIteraciones de la Fase de 3 colores
nInstancias = 3;
traza = 0;

for i = 1:nFicheros,
    nombreFichero = nombres(i).name;
    experimento3Coloreado = [];
    colorCromatico = zeros(nInstancias, 1);
    [nombreF, r] = strtok(nombreFichero, '.');
    nombreFicheroS = strcat(nombreF, '_3colorsC');
    fprintf('******** Ejecucion Grafo : %s\n', nombreFichero);
    for j = 1:nInstancias,
        fprintf('**** Instancia %d\n', j);
        datosPrograma = Estrategia_4colores();
        datosPrograma = inicializaExperimento(nombreFichero, datosPrograma, directorioL);
        estadoSistema = inicializaSistema(datosPrograma);
        experimento3Coloreado{j} = coloreadoCascada(datosPrograma, estadoSistema, nIteraciones4, nIteraciones3, traza);
    end

    %%%%%%%%%%% Salva los resultados de este experimento 
    cd(directorioS); %%%% directorio de los resultados (.mat y .txt)
    save(nombreFicheroS, 'experimento3Coloreado');
    cd ..;

    %%%%%%%%%%% Escribe el informe correspondiente para este experimento
    escribeInformeCascada(nombreFicheroS, experimento3Coloreado, directorioS);
end

%%%%%%%%% Elimina todas las variables temporales
clear all;