%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%% Demostracion del Coloreado Simple sin interfaz
%%%%%%%%% Unica fase: Coloreado con 3 colores (nIteraciones Final : 3500)
%%%%%%%%% Datos de Entrada: Directorio Graphs
%%%%%%%%% Datos de Salida : Directorio Results

%%%%%%%%% Cada experimento se repite tantas veces como nInstancias 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%% Elimina todas las variables temporales
clear all;

%%%%%% Nombre de los ficheros de grafos que existen en el directorio
%%%%%% "Graphs"
directorioL = 'Graphs';  %%%% directorio de los datos (grafos)
cd(directorioL);
nombres = dir('*.txt');
cd ..;
directorioS = 'Results'; %%%% directorio de los resultados (.mat y .txt)
if isdir(directorioS) == 0,
    mkdir(directorioS);
end

%%%%%% Adaptacion del path de Matlab
cd_actual = pwd;
arbol_cd = genpath(cd_actual);
addpath(arbol_cd);

nFicheros = length(nombres);
nIteraciones = 5000; %%%% nIteraciones de la Fase de 3 colores
nInstancias = 3;
traza = 0;

for i = 1:nFicheros,
    nombreFichero = nombres(i).name;
    experimento3Coloreado = [];
    colorCromatico = zeros(nInstancias, 1);
    [nombreF, r] = strtok(nombreFichero, '.');
    nombreFicheroS = strcat(nombreF, '_3colorsS');
    fprintf('******** Ejecucion Grafo : %s\n', nombreFichero);
    for j = 1:nInstancias,
        fprintf('**** Instancia %d\n', j);
        datosPrograma = Estrategia_3colores();
        datosPrograma = inicializaExperimento(nombreFichero, datosPrograma, directorioL);
        estadoSistema = inicializaSistema(datosPrograma);
        experimento3Coloreado{j} = coloreadoSimple(datosPrograma, estadoSistema, nIteraciones, traza);
    end

    %%%%%%%%%%% Salva los resultados de este experimento 
    cd(directorioS); %%%% directorio de los resultados (.mat y .txt)
    save(nombreFicheroS, 'experimento3Coloreado');
    cd ..;

    %%%%%%%%%%% Escribe el informe correspondiente para este experimento
    escribeInformeSimple(nombreFicheroS, experimento3Coloreado, directorioS);
end

%%%%%%%%% Elimina todas las variables temporales
clear all;