function [estadoSistema, colores, nColoreados, nCorrectos, ataquesMeta, densidadMeta] = ejecutaUnPaso(estadoSistema, datosPrograma)
%%%% Si estado == 0 (vagando solo)
%%%% Si estado == 1 (atacado)
%%%% Si estado == 2 (atacante)
%%%% Si estado == 3 (a la meta atacada de la cual ha salido un enemigo)
%%%% Si estado == 4 (en meta)

nAgentes = estadoSistema.nAgentes;
nCoordenadas = estadoSistema.nCoordenadas;

mundo = datosPrograma.mundo;

%%%%%%%%%%%%% INFORMACION DEL AGENTE
%%%%%%%% Informacion geometrica del agente
posicion = estadoSistema.posicion;
posicionObjetivo = estadoSistema.posicionObjetivo;
velocidad = estadoSistema.velocidad;
%%%%%%%% Informacion privada
radioVision = datosPrograma.parametrosAgentes.radioVision;
zonaPrivada = datosPrograma.parametrosAgentes.zonaPrivada;
nivelDesesperacion = estadoSistema.nivelDesesperacion;
limiteDesesperacion = datosPrograma.parametrosAgentes.limiteDesesperacion;
tipoHorizonte = datosPrograma.tipoHorizonte;

enemigos = datosPrograma.vecinos; 
amigos = datosPrograma.noVecinos;
opcionesEnemigos = datosPrograma.opcionesEnemigos;
opcionesAmigos   = datosPrograma.opcionesAmigos;

pEnemigos = pesoEnemigos(opcionesEnemigos, datosPrograma.pesosEnemigos);
pAmigos = pesoAmigos(opcionesAmigos, datosPrograma.pesosAmigos);
pAtaqueInterno = datosPrograma.parametrosAgentes.pAtaqueInterno;
pAtaqueExterno = datosPrograma.parametrosAgentes.pAtaqueExterno;
pObjetivo = datosPrograma.parametrosAgentes.pObjetivo;

%%%%%%%%%%%%% INFORMACION DE LAS METAS DE COLORES
nMetas = datosPrograma.parametrosMetas.nMetas;
posicionMetas = datosPrograma.parametrosMetas.posicion;
radioInfluencia = datosPrograma.parametrosMetas.rInfluencia;

vMax = datosPrograma.parametrosAgentes.zonaPrivada;
maximaNorma = datosPrograma.maximaNorma;

estado = zeros(nAgentes, 1);

ataquesMeta = [];
ataquesMeta.internos = zeros(nMetas, 1);
ataquesMeta.externos = zeros(nMetas, 1);

densidadMeta = zeros(nMetas, 1);

%%%%%%%%%%% Miramos si se ha alcanzado la meta
enMeta = alcanzadaMeta(posicion, posicionMetas, radioInfluencia);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%% TRATAMIENTO DENTRO DE LAS METAS: INFLUENCIA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%% Calculamos la velocidad a la meta para los que estan dentro de la
%%%%%%%% meta
%[vMeta, estanEnMeta] = calculaMeta(posicion, posicionMetas, enMeta, vMax);
estanEnMeta = find(enMeta);
if isempty(estanEnMeta) == 0,
    estado(estanEnMeta) = 4;
end

%%%%%%%%% A los que estan en meta les reduce el nivel de desesperacion
% idx = find(enMeta > 0);
% nivelDesesperacion(idx) = nivelDesesperacion(idx) - 1;

for i = 1:nMetas,
    densidadMeta(i) = length(find(enMeta == i));
end

%%%%%%%%%%% Si ha alcanzado el objetivo, se lo cambiamos
%%%%%%%%%%% y le damos un objetivo u otra meta
alcanzada = alcanzadaPosicion(posicion, posicionObjetivo, radioVision);
for i = 1:nAgentes,
    if ((estado(i) < 4) & (alcanzada(i) == 1)),
        posicionObjetivo(i, :) = inicializaObjetivos(mundo, tipoHorizonte, posicion(i, :), posicionMetas);
    end
end
estadoSistema.posicionObjetivo = posicionObjetivo;

vEnemigos = zeros(nAgentes, nCoordenadas);
vAmigos   = zeros(nAgentes, nCoordenadas);
for i = 1:nAgentes
    vecinos = calculaVecinos(i, posicion, radioVision);
    
    %%%%%%%%% CALCULO VELOCIDAD DE LOS ENEMIGOS VECINOS
    enemigosVecinos = intersect(enemigos{i}, vecinos);
    if isempty(enemigosVecinos) == 0,
        vEnemigos(i, :) = adaptaAgenteEnemigos(posicion(i, :), velocidad(i, :), posicion(enemigosVecinos, :), ...
                              velocidad(enemigosVecinos, :), vMax, opcionesEnemigos, zonaPrivada);
    end
    
    %%%%%%%%% CALCULO VELOCIDAD DE LOS AMIGOS VECINOS
    amigosVecinos = intersect(amigos{i}, vecinos);
    if isempty(amigosVecinos) == 0,
        vAmigos(i, :) = adaptaAgenteAmigos(posicion(i, :), velocidad(i, :), posicion(amigosVecinos, :), ...
                              velocidad(amigosVecinos, :), vMax, opcionesAmigos, zonaPrivada);
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%% TRATAMIENTO ATAQUES: INTERNO Y EXTERNO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
vBusqueda = zeros(nAgentes, nCoordenadas);

vAtaqueInterno = zeros(nAgentes, nCoordenadas);
if datosPrograma.parametrosAgentes.vAtaqueInterno == 1,
%%%%%%%% Ataque interno
    [vAtaqueInterno, atacantes, atacados, metasAtacadas] = ataqueInterno(posicion, posicionMetas, enMeta, ...
       enemigos, nivelDesesperacion, maximaNorma);
    nAtacados = length(atacados);
    if nAtacados > 0,
    %%%%%%%% Los atacados se van a cualquier parte del mundo    
%        posicionObjetivo(atacados, :) = puntosEnMundo(nAtacados, mundo);
    %%%%%%%% Los atacados se van a otra meta
        posicionObjetivo(atacados, :) = buscaOtraMeta(nAtacados, posicionMetas, metasAtacadas);
        vBusqueda = alAtaque(vBusqueda, atacados, posicion, posicionObjetivo, vMax);
        if datosPrograma.parametrosAgentes.vCuadrilla == 1,
            for i = 1:nAtacados,
                atacado = atacados(i); metaAtacada = metasAtacadas(i);
                cuadrilla = fueraDeMeta(enemigos{atacado}, enMeta);
                nCuadrilla = length(cuadrilla);
                if nCuadrilla > 0,
                    posicionObjetivo(cuadrilla, :) = repmat(posicionMetas(metaAtacada, :), nCuadrilla, 1);
                    vBusqueda = alAtaque(vBusqueda, cuadrilla, posicion, posicionObjetivo, vMax);
                    estado(cuadrilla) = 3;
                end
                ataquesMeta.internos(metaAtacada) = ataquesMeta.internos(metaAtacada) + 1;
            end
        end
        enMeta(atacados) = 0;
        estado(atacados) = 1; estado(atacantes) = 2;
        nivelDesesperacion(atacantes) = 0;
    end
end
%%%%%%%% Ataque externo
vAtaqueExterno = zeros(nAgentes, nCoordenadas);
if datosPrograma.parametrosAgentes.vAtaqueExterno == 1,
    [vAtaqueExterno, atacantes, atacados, metasAtacadas, metasDestino] = ataqueExterno(posicion, posicionMetas, enMeta, ...
        enemigos, nivelDesesperacion, limiteDesesperacion, maximaNorma);
    nAtacantes = length(atacantes);
    if nAtacantes > 0,
        nAtacados = length(atacados);
    %%%%%%%% Los atacados se van a cualquier parte del mundo    
%        posicionObjetivo(atacados, :) = puntosEnMundo(nAtacados, mundo);
    %%%%%%%% Los atacados se van a otra meta
        posicionObjetivo(atacados, :) = buscaOtraMeta(nAtacados, posicionMetas, metasAtacadas);
        vBusqueda = alAtaque(vBusqueda, atacados, posicion, posicionObjetivo, vMax);
        posicionObjetivo(atacantes, :) = posicionMetas(metasDestino, :);
        vBusqueda = alAtaque(vBusqueda, atacantes, posicion, posicionObjetivo, vMax);
        if datosPrograma.parametrosAgentes.vCuadrilla == 1,
            for i = 1:nAtacantes
                metaAtacada = metasDestino(i);
                for j = 1:nAtacados,
                    atacado = atacados(j);
                    cuadrilla = examinaAmigos(enemigos{atacado}, enMeta);            
                    nCuadrilla = length(cuadrilla);
                    if nCuadrilla > 0,
                        posicionObjetivo(cuadrilla, :) = repmat(posicionMetas(metaAtacada, :), nCuadrilla, 1);
                        estado(cuadrilla) = 3;
                    end
                    vBusqueda = alAtaque(vBusqueda, cuadrilla, posicion, posicionObjetivo, vMax);
                    ataquesMeta.externos(metaAtacada) = ataquesMeta.externos(metaAtacada) + 1;
                end
            end
        end
        enMeta(atacados) = 0;
        estado(atacados) = 1; estado(atacantes) = 2;
        nivelDesesperacion(atacantes) = 0;
    end
end

%%%%%%%%%%% Ajusta el estres
estadoSistema.nivelDesesperacion = controlaEstres(enMeta, nivelDesesperacion, limiteDesesperacion);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%% TRATAMIENTO VAGAR POR EL ESPACIO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% Calculamos la velocidad de busqueda de un objetivo
idx = find(estado == 0);
nidx = length(idx);
for i = 1:nidx,    
    vBusqueda(idx(i), :) = calculaBusquedaSimple(posicion(idx(i), :), posicionObjetivo(idx(i), :), vMax);
end

v = vEnemigos .* pEnemigos + vAmigos .* pAmigos + ...
    vAtaqueInterno .* pAtaqueInterno + vAtaqueExterno .* pAtaqueExterno + ...
    vBusqueda .* pObjetivo;

velocidadNueva = normalizaVector(v, maximaNorma);

%%%%%%%%%% Limitacion segun articulo
% velocidadNueva = zeros(nAgentes, nCoordenadas);
% peso = [pesoAtaque, pesoE, pesoA, pesoMeta, pesoObjetivo];
% for i = 1:nAgentes,
%     v = [vAtaque(i, :); vEnemigos(i, :); vAmigos(i, :); vMeta(i, :); vBusqueda(i, :)];
%     velocidadNueva(i, :) = limitacionVelocidad(v, peso, datosPrograma.maximaNorma);
% end    

%%%%%%%%%%% Adapta la posicion
posicionNueva = adaptaAgentes2D(posicion, velocidadNueva, mundo);
estadoSistema.posicion  = posicionNueva;
estadoSistema.velocidad = velocidadNueva;
estadoSistema.posicionObjetivo = posicionObjetivo;

%%%%%%%%% COMPRUEBA EL COLOREADO DEL GRAFO, CUANTOS SE ENCUENTRAN EN META Y
%%%%%%%%% CUANTOS SON CORRECTOS
enMeta = alcanzadaMeta(posicionNueva, posicionMetas, radioInfluencia);
[colores, nColoreados, nCorrectos] = coloreaGrafo(nMetas, enMeta, enemigos);