function b = enArista(punto, arista)
nPuntos  = size(punto, 1);
nAristas = size(arista, 1);

if nPuntos == 1 || nAristas == 1,
    x0 = repmat(arista(:,1)', nPuntos, 1);
    y0 = repmat(arista(:,2)', nPuntos, 1);
    dx = repmat(arista(:,3)', nPuntos, 1)-x0;
    dy = repmat(arista(:,4)', nPuntos, 1)-y0;
    xp = repmat(punto(:,1), 1, nAristas);
    yp = repmat(punto(:,2), 1, nAristas);
elseif nPuntos == nAristas
    x0 = edge(:,1);
    y0 = edge(:,2);
    dx = edge(:,3)-x0;
    dy = edge(:,4)-y0;
    xp = point(:,1);
    yp = point(:,2);
    
end


% Verificacion de aristas colineares
b1 = abs((xp-x0).*dy - (yp-y0).*dx)./(dx.*dx+dy.*dy) < 1e-13;

idx  = abs(dx) > abs(dy);
t = zeros(max(nPuntos, nAristas), 1);
t(idx) = (xp(idx)-x0(idx)) ./ dx(idx);
t(~idx) = (yp(~idx)-y0(~idx)) ./ dy(~idx);
b = t > -1e-14 & t-1 < 1e-14 & b1;




