function flag = enLinea(punto, linea)
nPuntos = size(punto, 1);
nLineas = size(linea, 1);

if nPuntos == 1 || nLineas == 1
    x0 = repmat(linea(:, 1)', nPuntos, 1);
    y0 = repmat(linea(:, 2)', nPuntos, 1);
    dx = repmat(linea(:, 3)', nPuntos, 1)-x0;
    dy = repmat(linea(:, 4)', nPuntos, 1)-y0;
    xp = repmat(punto(:, 1), 1, nLineas);
    yp = repmat(punto(:, 2), 1, nLineas);
elseif nPuntos == nLineas
    x0 = linea(:, 1);
    y0 = linea(:, 2);
    dx = linea(:, 3)-x0;
    dy = linea(:, 4)-y0;
    xp = punto(:, 1);
    yp = punto(:, 2);
end
b1 = abs((xp-x0).*dy - (yp-y0).*dx)./(dx.*dx+dy.*dy)<1e-13;
idx  = abs(dx)>abs(dy);
t = zeros(max(nPuntos, nLineas), 1);
t(idx) = (xp(idx)-x0(idx))./dx(idx);
t(~idx) = (yp(~idx)-y0(~idx))./dy(~idx);
flag = t>-1e-14 & t-1<1e-14 & b1;




