function escribeInformeSimple(nombreFichero, experimento, directorio)
if nargin > 2,
    cd(directorio); %%%% directorio de los resultados (.mat y .txt)
end

nInstancias = length(experimento);
nombreFicheroS = strcat(nombreFichero, '.txt');
fi = fopen(nombreFicheroS, 'w');
fprintf(fi, '***** Coloreado Simple %s\n', nombreFichero);
fprintf(fi, '*** N.instancias : %d\n', nInstancias);
fprintf(fi, '***************************************************\n');
nIteraciones3 = zeros(1, nInstancias);
nColoreados3 = zeros(1, nInstancias);
nCorrectos3 = zeros(1, nInstancias);
for i = 1:nInstancias,
    nIteraciones = experimento{i}.nIteraciones;
    nColoreados  = experimento{i}.nColoreados(nIteraciones);
    nCorrectos   = experimento{i}.nCorrectos(nIteraciones);
    nIteraciones3(i) = nIteraciones;
    nColoreados3(i)  = nColoreados;
    nCorrectos3(i)   = nCorrectos;
    fprintf(fi, '      Coloreado 3colores: nColoreados %d   nCorrectos %d    nIteraciones %d\n', ...
        nColoreados, nCorrectos, nIteraciones);
end
fprintf(fi, '***************************************************\n');
fprintf(fi, '***** Resultados Finales\n');
fprintf(fi, '** N. minimo, maximo, medio iteraciones Coloreado 3colores: %d %d %6.3f\n', ...
    min(nIteraciones3), max(nIteraciones3), mean(nIteraciones3));
fprintf(fi, '** N. minimo, maximo, medio coloreados Coloreado 3colores: %d %d %6.3f\n', ...
    min(nColoreados3), max(nColoreados3), mean(nColoreados3));
fprintf(fi, '** N. minimo, maximo, medio correctos Coloreado 3colores: %d %d %6.3f\n', ...
    min(nCorrectos3), max(nCorrectos3), mean(nCorrectos3));
fclose(fi);

if nargin > 2,
    cd ..;
end