function [vE, vA, vO] = evaluaVecindad(id, posicion, velocidad, enemigosVecinos, amigosVecinos, otrosVecinos, ...
                zonaPrivada, parametrosEnemigos, parametrosAmigos, parametrosOtros)
            
nCoordenadas = size(posicion, 2);            
if (parametrosEnemigos.detecta == 1) & (isempty(enemigosVecinos) == 0),
    vE = adaptaAgenteEnemigos(posicion(id, :), velocidad(id, :), posicion(enemigosVecinos, :), ...
                          velocidad(enemigosVecinos, :), zonaPrivada, parametrosEnemigos);
else
    vE = zeros(1, nCoordenadas);
end
if (parametrosAmigos.detecta == 1) & (isempty(amigosVecinos) == 0),
    vA = adaptaAgenteAmigos(posicion(id, :), velocidad(id, :), posicion(amigosVecinos, :), ...
                          velocidad(amigosVecinos, :), parametrosAmigos);
else
    vA = zeros(1, nCoordenadas);
end
if (parametrosOtros.detecta == 1) & (isempty(otrosVecinos) == 0)
    vO = adaptaAgenteOtros(posicion(id, :), velocidad(id, :), posicion(otrosVecinos, :), ...
                          velocidad(otrosVecinos, :), zonaPrivada, parametrosOtros);
else
    vO = zeros(1, nCoordenadas);
end
