function [vGE, vGA, vGO] = evaluaVecindadGlobal(estadoSistema, datosPrograma)
posicion = estadoSistema.posicion;
velocidad = estadoSistema.velocidad;
nAgentes = estadoSistema.nAgentes;
nCoordenadas = estadoSistema.nCoordenadas;

enemigos = estadoSistema.vecinos;
amigos   = estadoSistema.noVecinos;

zonaPrivada = datosPrograma.parametrosAgentes.zonaPrivada;

parametrosEnemigos = datosPrograma.parametrosVelocidad.enemigos;
parametrosAmigos = datosPrograma.parametrosVelocidad.amigos;
parametrosOtros = datosPrograma.parametrosVelocidad.otros;

vGE = zeros(nAgentes, nCoordenadas);
vGA = zeros(nAgentes, nCoordenadas);
vGO = zeros(nAgentes, nCoordenadas);
for i = 1:nAgentes,
    enemigosVecinos = enemigos{i};
    amigosVecinos = amigos{i};
    otrosVecinos = setdiff(1:nAgentes, union(enemigosVecinos, amigosVecinos));
    [vE, vA, vO] = evaluaVecindad(i, posicion, velocidad, ...
            enemigosVecinos, amigosVecinos, otrosVecinos, ...
            zonaPrivada, parametrosEnemigos, parametrosAmigos, parametrosOtros);
    vGE(i, :) = vE; vGA(i, :) = vA; vGO(i, :) = vO;
end