function [vLE, vLA, vLO] = evaluaVecindadLocal(estadoSistema, datosPrograma)
posicion = estadoSistema.posicion;
velocidad = estadoSistema.velocidad;
nAgentes = estadoSistema.nAgentes;
nCoordenadas = estadoSistema.nCoordenadas;

enemigos = estadoSistema.vecinos;
amigos   = estadoSistema.noVecinos;

radioVision = datosPrograma.parametrosAgentes.radioVision;
zonaPrivada = datosPrograma.parametrosAgentes.zonaPrivada;

parametrosEnemigos = datosPrograma.parametrosVelocidad.enemigos;
parametrosAmigos = datosPrograma.parametrosVelocidad.amigos;
parametrosOtros = datosPrograma.parametrosVelocidad.otros;

vLE = zeros(nAgentes, nCoordenadas);
vLA = zeros(nAgentes, nCoordenadas);
vLO = zeros(nAgentes, nCoordenadas);
for i = 1:nAgentes,
    d = distanciaEuclidea(posicion(i, :), posicion);
    idx = find(d < radioVision);
    cercanos = setdiff(idx, i);
    enemigosVecinos = intersect(cercanos, enemigos{i});
    amigosVecinos = intersect(cercanos, amigos{i});
    otrosVecinos = setdiff(1:nAgentes, union(enemigosVecinos, amigosVecinos));
    [vE, vA, vO] = evaluaVecindad(i, posicion, velocidad, ...
            enemigosVecinos, amigosVecinos, otrosVecinos, ...
            zonaPrivada, parametrosEnemigos, parametrosAmigos, parametrosOtros);
    vLE(i, :) = vE; vLA(i, :) = vA; vLO(i, :) = vO;
end