function datosPrograma = iniciaAgentes()
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% PARAMETROS DEL MUNDO
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Limites
mundo = inicializaMundo2D(-200, 200, -200, 200);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% PARAMETROS DE LAS METAS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parametrosM = [];
%%%%%%%%%%%% Posicion y color de todas las posibles metas (1, 2, 3 y 4 metas)
parametrosM.posicionTodasLasMetas{1} = [-50 50; 0 0]';
parametrosM.posicionTodasLasMetas{2} = [-75 0 75; -50 50 -50]';
parametrosM.posicionTodasLasMetas{3} = [-75 -75 75 75; -50 50 50 -50]';
parametrosM.color = {'r', 'g', 'b', 'c', 'k'};
%%%%%%%%%%%% Numero de metas por defecto (3-coloreado)
parametrosM.nMetas = 3;
%%%%%%%%%%%% Posicion de las Metas 
parametrosM.posicion = parametrosM.posicionTodasLasMetas{2};
%%%%%%%%%%%% Zona de influencia de las Metas 
%%%%%%%%%%%% (si/no, radio de influencia y peso)
parametrosM.vInfluencia = 1;
parametrosM.radioInfluencia = 20;
parametrosM.pInfluencia = 1.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% PARAMETROS DE LOS AGENTES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parametrosA = [];
%%%%%%%%%%% Radio de vision del vecindario de cada agente
parametrosA.radioVision = 50;
parametrosA.limiteDesesperacion = 100;
%%%%%%%%%%% Rafio de zona privada que no debe sobreparse alrededor de un
%%%%%%%%%%% individuo
parametrosA.zonaPrivada = 10;
%%%%%%%%%%% Ataca (si/no, peso)
parametrosA.vAtaque = 0;
parametrosA.pAtaque = 1.0;
%%%%%%%%%%% Tiene en cuenta todas las metas (si/no, peso)
parametrosA.vTodasLasMetas = 1;
parametrosA.pMetas = 1.0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% PARAMETROS DE LA VELOCIDAD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
parametrosV = [];
parametrosV.enemigos = [];
%%%%%%%%%%% Fuerzas enemigos: alineacion, separacion y huida
%%%%%%%%%%% Para todos los casos (si/no, peso)
parametrosV.enemigos.detecta = 1;
parametrosV.enemigos.vAlineacion = 1;
parametrosV.enemigos.pAlineacion = 1.0;
parametrosV.enemigos.vSeparacion = 0;
parametrosV.enemigos.pSeparacion = 1.0;
parametrosV.enemigos.vHuida = 0;
parametrosV.enemigos.pHuida = 1.0;

parametrosV.amigos = [];
%%%%%%%%%%% Fuerzas amigos: alineacion, cohesion y busqueda
%%%%%%%%%%% Para todos los casos (si/no, peso)
parametrosV.amigos.detecta = 1;
parametrosV.amigos.vAlineacion = 1;
parametrosV.amigos.pAlineacion = 1.0;
parametrosV.amigos.vCohesion = 0;
parametrosV.amigos.pCohesion = 1.0;
parametrosV.amigos.vBusqueda = 0;
parametrosV.amigos.pBusqueda = 1.0;

parametrosV.otros = [];
parametrosV.otros.detecta = 0;
parametrosV.otros.vAlineacion = 0;
parametrosV.otros.pAlineacion = 1.0;
parametrosV.otros.vCohesion = 0;
parametrosV.otros.pCohesion = 1.0;
parametrosV.otros.vBusqueda = 0;
parametrosV.otros.pBusqueda = 1.0;
parametrosV.otros.vSeparacion = 0;
parametrosV.otros.pSeparacion = 1.0;
parametrosV.otros.vHuida = 0;
parametrosV.otros.pHuida = 1.0;

%%%%%%%%%%% Existe ruido (si/no, radio del ruido, peso)
parametrosV.vRuido = 1;
parametrosV.rRuido = 10;
parametrosV.pRuido = 2.0;

%%%%%%%%%%% Limitacion de la velocidad (si/no, peso)
parametrosV.vLimita = 0;
parametrosV.pLimita = 1.0;

datosPrograma.mundo = mundo;
datosPrograma.parametrosMetas  = parametrosM;
datosPrograma.parametrosAgentes = parametrosA;
datosPrograma.parametrosVelocidad = parametrosV;

%%%% Vecindario (0 = local / 1 = global)
datosPrograma.vecindario = 0;
%%%% Horizonte ([] = nulo / 0 = cercano / 1 = global)
datosPrograma.horizonte = 0;
