function estadoSistema = inicializaSistema(datosPrograma)
mundo = datosPrograma.mundo;

nAgentes = datosPrograma.nAgentes;
nCoordenadas = mundo.nCoordenadas;

posicion = puntosEnMundo(nAgentes, mundo);
velocidad = vectorAleatorio(nAgentes, [-1 -1], [1 1]);

estadoSistema.nAgentes = nAgentes;
estadoSistema.nCoordenadas = nCoordenadas;

estadoSistema.posicion = posicion;
estadoSistema.velocidad = velocidad;

estadoSistema.nivelDesesperacion = zeros(nAgentes, 1);

tipoHorizonte = datosPrograma.tipoHorizonte;
posicionMetas = datosPrograma.parametrosMetas.posicion;
estadoSistema.posicionObjetivo = inicializaObjetivos(mundo, tipoHorizonte, posicion, posicionMetas);