function varargout = interfazMetas(varargin)
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @interfazMetas_OpeningFcn, ...
                   'gui_OutputFcn',  @interfazMetas_OutputFcn, ...
                   'gui_CreateFcn',  @interfazMetas_CreateFcn, ...
                   'gui_DeleteFcn',  @interfazMetas_DeleteFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end

function interfazMetas_OpeningFcn(hObject, eventdata, handles, varargin)
disp('estoy en open metas')
parametros = varargin{1};
handles.output = hObject;
cargaParametros(parametros);
handles.UserData = parametros;
guidata(hObject, handles);
uiwait(hObject);

function varargout = interfazMetas_OutputFcn(hObject, eventdata, handles) 
disp('estoy en output metas')
varargout{1} = handles.output;
varargout{2} = handles.UserData;
delete(hObject);

function interfazMetas_CloseRequestFcn(hObject, eventdata, handles, varargin)
disp('estoy en close metas')
handles.output = 'Close';
uiresume(hObject);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Tipo de metas
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function vDosMetas_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function vDosMetas_Callback(hObject, eventdata, handles)
flag = get(hObject, 'Value');
if flag == 1,
    handles.UserData.nMetas = 2;
    handles.UserData.posicion = handles.UserData.posicionTodasLasMetas{1};
    guidata(hObject, handles);
    ajustaBotonesPosicion(2);
    setPosicion(2, handles.UserData.posicion);
end

function vTresMetas_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function vTresMetas_Callback(hObject, eventdata, handles)
flag = get(hObject, 'Value');
if flag == 1,
    handles.UserData.nMetas = 3;
    handles.UserData.posicion = handles.UserData.posicionTodasLasMetas{2};
    guidata(hObject, handles);
    ajustaBotonesPosicion(3);
    setPosicion(3, handles.UserData.posicion);
end

function vCuatroMetas_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function vCuatroMetas_Callback(hObject, eventdata, handles)
flag = get(hObject, 'Value');
if flag == 1,
    handles.UserData.nMetas = 4;
    handles.UserData.posicion = handles.UserData.posicionTodasLasMetas{3};
    guidata(hObject, handles);
    ajustaBotonesPosicion(4);
    setPosicion(4, handles.UserData.posicion);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Meta 1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xMeta1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function xMeta1_Callback(hObject, eventdata, handles)
handles.UserData.posicion(1, 1) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

function yMeta1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function yMeta1_Callback(hObject, eventdata, handles)
handles.UserData.posicion(1, 2) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Meta 2
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xMeta2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function xMeta2_Callback(hObject, eventdata, handles)
handles.UserData.posicion(2, 1) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

function yMeta2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function yMeta2_Callback(hObject, eventdata, handles)
handles.UserData.posicion(2, 2) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Meta 3
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xMeta3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function xMeta3_Callback(hObject, eventdata, handles)
handles.UserData.posicion(3, 1) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

function yMeta3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function yMeta3_Callback(hObject, eventdata, handles)
handles.UserData.posicion(3, 2) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Meta 4
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function xMeta4_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function xMeta4_Callback(hObject, eventdata, handles)
handles.UserData.posicion(4, 1) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

function yMeta4_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function yMeta4_Callback(hObject, eventdata, handles)
handles.UserData.posicion(4, 2) = str2double(get(hObject, 'String'));
guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% Zona de Influencia
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function radioInfluencia_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function radioInfluencia_Callback(hObject, eventdata, handles)
handles.UserData.rInfluencia = str2double(get(hObject, 'String'));
guidata(hObject, handles);

function pInfluencia_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function pInfluencia_Callback(hObject, eventdata, handles)
handles.UserData.pInfluencia = str2double(get(hObject, 'String'));
guidata(hObject, handles);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% BOTONES OK y CANCEL
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function botonOK_Callback(hObject, eventdata, handles)
handles.output = 'OK';
guidata(hObject, handles);
uiresume(handles.fInterfazMetas);

function botonCancel_Callback(hObject, eventdata, handles)
handles.output = 'Cancel';
guidata(hObject, handles);
uiresume(handles.fInterfazMetas);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%% OTRAS FUNCIONES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function h = buscaObjeto(nombre)
h = findobj('Tag', nombre);

function setValor(nombre, valor)
h = buscaObjeto(nombre);
set(h, 'Value', valor);

function setCadena(nombre, valor)
h = buscaObjeto(nombre);
set(h, 'String', num2str(valor));

function ajustaBotonesPosicion(numero)
if numero == 2,
    dos = 1; tres = 0; cuatro = 0;
elseif numero == 3,
    dos = 0; tres = 1; cuatro = 0;
else
    dos = 0; tres = 0; cuatro = 1;
end
setValor('vDosMetas', dos);
setValor('vTresMetas', tres);
setValor('vCuatroMetas', cuatro);

function setPosicion(nMetas, posicionMeta)
setCadena('xMeta1', posicionMeta(1, 1));
setCadena('yMeta1', posicionMeta(1, 2));
setCadena('xMeta2', posicionMeta(2, 1));
setCadena('yMeta2', posicionMeta(2, 2));
if nMetas > 2,
    x3 = posicionMeta(3, 1); y3 = posicionMeta(3, 2);
    if nMetas > 3,
        x4 = posicionMeta(4, 1); y4 = posicionMeta(4, 2);
    else
        x4 = 0; y4 = 0;
    end
else
    x3 = 0; y3 = 0; x4 = 0; y4 = 0;
end
setCadena('xMeta3', x3);
setCadena('yMeta3', y3);
setCadena('xMeta4', x4);
setCadena('yMeta5', y4);

function resetMetas_Callback(hObject, eventdata, handles)
nMetas = handles.UserData.nMetas;
if nMetas == 2,
    handles.UserData.posicion = handles.UserData.posicionTodasLasMetas{1};
elseif nMetas == 3,
    handles.UserData.posicion = handles.UserData.posicionTodasLasMetas{2};
else
    handles.UserData.posicion = handles.UserData.posicionTodasLasMetas{3};
end
guidata(hObject, handles);
setPosicion(handles, nMetas);

function cargaParametros(parametros)
ajustaBotonesPosicion(parametros.nMetas);
setPosicion(parametros.nMetas, parametros.posicion);
setCadena('radioInfluencia', parametros.rInfluencia);
setCadena('pesoInfluencia', parametros.pInfluencia);