function punto = interseccionLineas(linea1, linea2)
x1 =  linea1(1); y1 =  linea1(2); dx1 = linea1(3); dy1 = linea1(4);
x2 =  linea2(1); y2 =  linea2(2); dx2 = linea2(3); dy2 = linea2(4);

n1 = length(x1);
n2 = length(x2);

% indices de las lineas paralelas
idx_paralelas = abs(dx1.*dy2-dx2.*dy1)<1e-14;

% indices de las lineas colineares
idx_colineares = abs((x2-x1).*dy1-(y2-y1).*dx1)<1e-14 & idx_paralelas;

x(idx_colineares) = Inf;
y(idx_colineares) = Inf;
x(idx_paralelas & ~idx_colineares) = NaN;
y(idx_paralelas & ~idx_colineares) = NaN;

i = ~idx_paralelas;

if n1 == n2,
	x(i) = ((y2(i)-y1(i)).*dx1(i).*dx2(i) + x1(i).*dy1(i).*dx2(i) - x2(i).*dy2(i).*dx1(i)) ./ ...
        (dx2(i).*dy1(i)-dx1(i).*dy2(i)) ;
	y(i) = ((x2(i)-x1(i)).*dy1(i).*dy2(i) + y1(i).*dx1(i).*dy2(i) - y2(i).*dx2(i).*dy1(i)) ./ ...
        (dx1(i).*dy2(i)-dx2(i).*dy1(i)) ;
elseif n1 == 1
	x(i) = ((y2(i)-y1).*dx1.*dx2(i) + x1.*dy1.*dx2(i) - x2(i).*dy2(i).*dx1) ./ ...
        (dx2(i).*dy1-dx1.*dy2(i)) ;
	y(i) = ((x2(i)-x1).*dy1.*dy2(i) + y1.*dx1.*dy2(i) - y2(i).*dx2(i).*dy1) ./ ...
        (dx1.*dy2(i)-dx2(i).*dy1) ;
elseif n2 == 1
   	x(i) = ((y2-y1(i)).*dx1(i).*dx2 + x1(i).*dy1(i).*dx2 - x2.*dy2.*dx1(i)) ./ ...
        (dx2.*dy1(i)-dx1(i).*dy2) ;
	y(i) = ((x2-x1(i)).*dy1(i).*dy2 + y1(i).*dx1(i).*dy2 - y2.*dx2.*dy1(i)) ./ ...
        (dx1(i).*dy2-dx2.*dy1(i)) ;
else
   	x(i) = ((y2(i)-y1(i)).*dx1(i).*dx2(i) + x1(i).*dy1(i).*dx2(i) - x2(i).*dy2(i).*dx1(i)) ./ ...
        (dx2(i).*dy1(i)-dx1(i).*dy2(i)) ;
	y(i) = ((x2(i)-x1(i)).*dy1(i).*dy2(i) + y1(i).*dx1(i).*dy2(i) - y2(i).*dx2(i).*dy1(i)) ./ ...
        (dx1(i).*dy2(i)-dx2(i).*dy1(i)) ;
end
punto = [x' y'];