function [vecinos, no_vecinos] = lee_aristas(nombre, nlineas)
fid = fopen(nombre, 'r');
for i = 1:nlineas+1,
    linea = fgetl(fid);
end
empiezaE = (linea(1) == 'e');
fclose(fid);

if empiezaE == 1,
    [desde hasta] = textread(nombre, 'e %d %d', 'headerlines', nlineas);
else
    [desde hasta] = textread(nombre, '%d %d', 'headerlines', nlineas);
end
nAristas = length(desde);
nElementos = max([max(desde) max(hasta)]);
mapa = zeros(nElementos, nElementos);
for i = 1:nAristas,
    mapa(desde(i), hasta(i)) = 1;
    mapa(hasta(i), desde(i)) = 1;
end
vecinos = []; no_vecinos = [];
for i = 1:nElementos,
    vecinos{i} = find(mapa(i, :));
    no_vecinos{i} = setdiff(1:nElementos, vecinos{i});
end    
    