function [vecinos, no_vecinos] = lee_grafo(nombre, nlineas)
cadena = textread(nombre, '%c', 'headerlines', nlineas);
[t, r] = strtok(cadena, ':');
%%%%%%%%%%%% Son los nodos colocados a
%%%%%%%%%%%% distancia 1
vecinos = [];
while length(r) > 0,
    id = str2num(t');
    [t, r] = strtok(r(2:end), '.');
    if t == '0',
        vecinos{id} = [];
    else
        veci = strread(t,'%d','delimiter',',');
        vecinos{id} = veci';
    end
    cadena = r(2:end);
    [t, r] = strtok(cadena, ':');
end
nElementos = length(vecinos);
%%%%%%%%%%%% Son los vecinos de los enemigos 
%%%%%%%%%%%%(nodos colocados a distancia 2)
no_vecinos = [];
for i = 1:nElementos,
    idx = vecinos{i};
    if isempty(idx) == 0,
        lista = [];
        nidx = length(idx);
        for j = 1:nidx,
            lista = [lista vecinos{idx(j)}];
        end
        no_vecinos{i} = unique(lista);
    else
        no_vecinos{i} = [];
    end
end