function [enMeta, metaCercana, d_minima] = metaMasCercana(posicion, posicionMetas, radioInfluencia)
nElementos = size(posicion, 1);
nMetas = size(posicionMetas, 1);
d = zeros(nMetas, nElementos);
for j = 1:nMetas,
    d(j, :) = distanciaEuclidea(posicion, posicionMetas(j, :));
end
[d_minima, metaCercana] = min(d);

enMeta = zeros(nElementos, 1);
idx = find(d_minima < radioInfluencia);
if isempty(idx) == 0,
    enMeta(idx) = metaCercana(idx);
end