function [vn, norma] = normalizaVector(v, maximaNorma)
dim = size(v);
if dim(1)==1 || dim(2)==1,
    norma = sqrt(sum(v.*v)); 
    vn = v/norma;
else
    norma = sqrt(sum(v.*v, 2));
    vn = v./repmat(norma, [1 dim(2)]);
end
vn = quitaNaN(vn);
vn = quitaInf(vn);
if nargin == 2,
    idx = find(norma > maximaNorma);
    if isempty(idx) == 0,
        vn(idx, :) = vn(idx, :) .*maximaNorma;
    else
        vn = v;
    end
end