function d = posicionEnLinea(punto, linea)
nLineas = size(linea, 1);
nPuntos = size(punto, 1);

if nPuntos == nLineas,
    dxl = linea(:, 3);
    dyl = linea(:, 4);
    dxp = punto(:, 1) - linea(:, 1);
    dyp = punto(:, 2) - linea(:, 2);

    d = (dxp.*dxl + dyp.*dyl)./(dxl.*dxl+dyl.*dyl);

else
    dxl = repmat(linea(:,3)', nPuntos, 1);
    dyl = repmat(linea(:,4)', nPuntos, 1);
    dxp = repmat(punto(:,1), 1, nLineas) - repmat(linea(:,1)', nPuntos, 1);
    dyp = repmat(punto(:,2), 1, nLineas) - repmat(linea(:,2)', nPuntos, 1);

    d = (dxp.*dxl + dyp.*dyl)./(dxl.*dxl+dyl.*dyl);
end