function distanciaCamino = puntoEnCaminoDistancia(puntos, longitud)
for i = 1:nPuntos,
    segmento = puntos(i+1, :) - puntos(i, :);
    d = distanciaPuntoLinea(punto, puntos(i+1, :), puntos(i, :));
    if d < distanciaMinima,
        distanciaMinima = d;
        distanciaCamino = longitudCamino + proyeccion;
    end
    longitudCamino = longitudCamino + longitud(i);
end


// ----------------------------------------------------------------------------
// given a distance along the path, convert it to a point on the path


OpenSteer::Vec3 
OpenSteer::PolylinePathway::mapPathDistanceToPoint (float pathDistance)
{
    // clip or wrap given path distance according to cyclic flag
    float remaining = pathDistance;
    if (cyclic)
    {
        remaining = (float) fmod (pathDistance, totalPathLength);
    }
    else
    {
        if (pathDistance < 0) return points[0];
        if (pathDistance >= totalPathLength) return points [pointCount-1];
    }

    // step through segments, subtracting off segment lengths until
    // locating the segment that contains the original pathDistance.
    // Interpolate along that segment to find 3d point value to return.
    Vec3 result;
    for (int i = 1; i < pointCount; i++)
    {
        segmentLength = lengths[i];
        if (segmentLength < remaining)
        {
            remaining -= segmentLength;
        }
        else
        {
            float ratio = remaining / segmentLength;
            result = interpolate (ratio, points[i-1], points[i]);
            break;
        }
    }
    return result;
}


// ----------------------------------------------------------------------------
// computes distance from a point to a line segment 
//
// (I considered moving this to the vector library, but its too
// tangled up with the internal state of the PolylinePathway instance)


float 
OpenSteer::PolylinePathway::pointToSegmentDistance (const Vec3& point,
                                                    const Vec3& ep0,
                                                    const Vec3& ep1)
{
    // convert the test point to be "local" to ep0
    local = point - ep0;

    // find the projection of "local" onto "segmentNormal"
    segmentProjection = segmentNormal.dot (local);

    // handle boundary cases: when projection is not on segment, the
    // nearest point is one of the endpoints of the segment
    if (segmentProjection < 0)
    {
        chosen = ep0;
        segmentProjection = 0;
        return Vec3::distance (point, ep0);
    }
    if (segmentProjection > segmentLength)
    {
        chosen = ep1;
        segmentProjection = segmentLength;
        return Vec3::distance (point, ep1);
    }

    // otherwise nearest point is projection point on segment
    chosen = segmentNormal * segmentProjection;
    chosen +=  ep0;
    return Vec3::distance (point, chosen);
}


// ----------------------------------------------------------------------------
