function [velocidadN, enMeta] = velocidadAgentes(estadoSistema, enMeta, metaCercana, datosPrograma)
posicionMeta = datosPrograma.parametrosMetas.posicion;
nCoordenadas = size(posicionMeta, 2);

nAgentes = estadoSistema.nAgentes;
enemigos = estadoSistema.vecinos;
amigos = estadoSistema.noVecinos;
posicion = estadoSistema.posicion;
velocidad = estadoSistema.velocidad;
dLimite = datosPrograma.parametrosAgentes.zonaPrivada;
radioVision = datosPrograma.parametrosAgentes.radioVision;
parametrosEnemigos = datosPrograma.parametrosVelocidad.enemigos;
parametrosAmigos   = datosPrograma.parametrosVelocidad.amigos;

%%%%%%%%% Nueva velocidad
velocidadN = zeros(nAgentes, 2);

for i = 1:nAgentes,
    vE  = zeros(1, nCoordenadas);
    vA  = zeros(1, nCoordenadas);
    vIM = zeros(1, nCoordenadas);
    vM  = zeros(1, nCoordenadas);
    vR  = zeros(1, nCoordenadas);

    %%%%%%%%% CALCULO DE LOS VECINOS DEL AGENTE I-ESIMO
    vecinos = calculaVecinos(i, posicion, radioVision);
    
    %%%%%%%%% CALCULO VELOCIDAD DE LOS ENEMIGOS VECINOS
    enemigosVecinos = intersect(enemigos{i}, vecinos);
    if isempty(enemigosVecinos) == 0,
        vE = adaptaAgenteEnemigos(posicion(i, :), velocidad(i, :), posicion(enemigosVecinos, :), ...
                              velocidad(enemigosVecinos, :), parametrosEnemigos, dLimite);
    end
    
    %%%%%%%%% CALCULO VELOCIDAD DE LOS AMIGOS VECINOS
    amigosVecinos = intersect(amigos{i}, vecinos);
    if isempty(amigosVecinos) == 0,
        vA = adaptaAgenteAmigos(posicion(i, :), velocidad(i, :), posicion(amigosVecinos, :), ...
                              velocidad(amigosVecinos, :), parametrosAmigos);
    end
    
    %%%%%%%%% CALCULO VELOCIDAD DE LA ZONA DE INFLUENCIA DE LAS METAS 
    %%%%%%%%% SI ESTA EN UNA ZONA DE INFLUENCIA
    enLaMeta = intersect(i, enMeta);
    if isempty(enLaMeta) == 0,
        agentesEnMeta = find(enMeta == enLaMeta);
        posiblesEnemigos = intersect(enemigos{i}, agentesEnMeta);
        if isempty(posiblesEnemigos) == 0,
            posicionEnemigos = posicion(posiblesEnemigos, :);
        else
            posicionEnemigos = [];
        end
        otros = setdiff(agentesEnMeta, [posiblesEnemigos i]);
        if isempty(otros) == 0,
            posicionOtros = posicion(otros, :);
        else
            posicionOtros = [];
        end
        if isempty(union(posiblesEnemigos, otros)) == 0,
            vIM = adaptaAgenteZonaInfluencia(posicion(i, :), velocidad(i, :), ...
                posicionEnemigos, posicionOtros, datosPrograma.parametrosMetas);
        end
    end

    %%%%%%%%% CALCULO VELOCIDAD CORRESPONDIENTES A LAS METAS
    vM = adaptaAgenteMetas(posicion(i, :), metaCercana(i), ...
        datosPrograma.parametrosVelocidad, datosPrograma.parametrosMetas);
   
    %%%%%%%%% CALCULO VELOCIDAD RUIDO
    if datosPrograma.parametrosVelocidad.vRuido == 1,
        vR = calculaRuido(datosPrograma.parametrosVelocidad.radioRuido, datosPrograma.parametrosVelocidad.pRuido);
    end
    
    velocidadN(i, :) = vE + vA + vIM + vM + vR;
end