function C = maxproduct(A,B)
 % calcula el maxproduct de las matrices A y B
 % tal y como esta definido en la pg. 4 ec.10
 % de los apuntes de Ritter, Sussner y Diaz de Leon:
 % Morphological Associative Memories
 %
 % A es una matriz de tamaño: mxp
 % B es una matriz de tamaño: pxn
 % C es una matriz de tamaño: mxn
 % c_ij = max(a_ik + b_kj)
 
 [m,p] = size(A);
 [q,n] = size(B);
 if not(p==q) disp('error en el tamaño de las matrices');
 else 
     for i = 1:m
         for j = 1:n
            
             C(i,j) = max(A(i,:)+B(:,j)');
             
             % C(i,j) = 0; % inicializa el elemento i,j de la matriz C
             % for k = 1:p
             %    AUX = A(i,k)+B(k,j);
             %    C(i,j) = max()
             % end
         end
     end
 end
end
 