function Mxy = mem_dilatativa(X,Y)

% Matrices de patrones asociados, associated pattern matrices
% X e Y, (X,Y)
% X matriz de dimension nxk, k vectores de dimension nx1
% Y matriz de dimension mxk, k vectores de dimension mx1
% Wxy matriz morfologica de tamaño mxn, pg.7 ec. 23
% Mxy matriz morfologica de tamaño mxn, pg.7 ec. 23

[n,p] = size(X);
[m,q] = size(Y);

 Mmax = zeros(m,n,p);
 Mxy = zeros(m,n);
 
if not(p==q) disp('error en el tamaño de las matrices');
else 
    %for i = 1:m
    %     for j = 1:n
            
    for k = 1:p
        Mmax(:,:,k) = minproduct(Y(:,k),(-X(:,k))');
    end
        % end
    %end
    
    Mxy(:,:) = max(Mmax,[],3);% OJO! dimension 3
end

end
