function Wxy = mem_erosiva(X,Y)

% Matrices de patrones asociados, associated pattern matrices
% X e Y, (X,Y)
% X matriz de dimension nxk, k vectores de dimension nx1
% Y matriz de dimension mxk, k vectores de dimension mx1
% Wxy matriz morfologica de tamaño mxn, pg.7 ec. 23
% Mxy matriz morfologica de tamaño mxn, pg.7 ec. 23

[n,p] = size(X);
[m,q] = size(Y);

 Wmin = zeros(m,n,p);
 Wxy = zeros(m,n);
 
if not(p==q) disp('error en el tamaño de las matrices');
else 
    
            
    for k = 1:p
        Wmin(:,:,k) = minproduct(Y(:,k),(-X(:,k))');
    end
    
    Wxy(:,:) = min(Wmin,[],3); % OJO! dimension 3
    
    
end

end
