% pru_maxproduct.m

n = 3;
m = 4;
k = 2;

A = round(5*rand(n,k));
B = round(5*rand(k,m));
D = round(5*rand(k,m));
C1 = maxproduct(A,B);
C2 = minproduct(A,B);
C3 = minproduct(D,B);
C4 = maxproduct(D,B);
% ec.16 pg 5
% A* = -(At)
% C2 = C5, minproduct(A,B) = -(maxproduct(-B',-A')'), ec.16 pg 5
C5 = -(maxproduct(-B',-A')')


% Memorias morfologicas asociativas: W y M

% Dos vectores: x e y
% x vector de tamaño nx1
% y vector de tamaño mx1
% W = maxproduct(y,(-x)'), ec.21 pg 6

x = round(5*rand(n,1));
y = round(5*rand(m,1));
W = maxproduct(y,(-x)');

% maxproduct(W,x) = y, ec.22 pg 6
maxproduct(W,x)

% Matrices de patrones asociados, associated pattern matrices
% X e Y, (X,Y)
% X matriz de dimension nxk, k vectores de dimension nx1
% Y matriz de dimension mxk, k vectores de dimension mx1
% Wxy matriz morfologica de tamaño mxn, pg.7 ec. 23
% Mxy matriz morfologica de tamaño mxn, pg.7 ec. 23

X = round(5*rand(n,k));
Y = round(5*rand(m,k));

 Wxy = mem_erosiva(X,Y);
 Mxy = mem_dilatativa(X,Y);
 
 
 
 % Ejemplo 1, pg. 7
 
 k = 3; % 3 vectores
 n = 3; % dim 3x1, x
 m = 3; % dim 3x1, y
 
 % X = [x1,x2,x3]
 X = [ 0  0  0 ;
       0 -2 -3 ;
       0 -4  0 ]; 
   
 % Y = [y1,y2,y3] 
 Y = [ 0 -1  0 ;
       1 -1 -2 ;
       0  0  0 ]; 

 Wxy = mem_erosiva(X,Y);
%     -1     0     0
%     -2     1    -2
%      0     0     0
 Mxy = mem_dilatativa(X,Y); 
%      0     3     3
%      1     1     3
%      0     3     4


 % Comprobar que se recuperan los vectores y correspondientes. 
 % ecs. 30,31
 % pg.8
 
 % y1 = Y(:,1)
 maxproduct(Wxy,X(:,1))
 minproduct(Mxy,X(:,1))
 
 % y2 = Y(:,2)
 maxproduct(Wxy,X(:,2))
 minproduct(Mxy,X(:,2))
 
 % y3 = Y(:,3)
 maxproduct(Wxy,X(:,3))
 minproduct(Mxy,X(:,3))

 
 % Y las matrices Y = maxproduct(Wxy,X)? def. maxproduct perfect memory pg.8
 
 maxproduct(Wxy,X)
 
 % Y = minproduct(Mxy,X)? def. minproduct perfect memory pg.8
 minproduct(Mxy,X)
 
 
 % Teoremas 
 
 % Tma2. Existencia de memorias de recuerdo perfecto
 % La memoria dilativa Wxy es max-perfect para (X,Y) para cada uno de los k
 % vectores cada fila de la matriz: [yk x (-x'k)t]-Wxy  contiene un cero.
 
 % En la matriz entre corchetes el vector x'k hace referencia a un vector
 % con ruido. Esta matriz es
 % maxproduct(Y(:,k),(-XR(:,k))')/minproduct(Y(:,k),(-XR(:,k))')?
 
 % Genero una matriz XR con ruido:
 
 XR = X+round(rand(n,k));
 
 % maxproduct(Y(:,k),(-XR(:,k))')
 WR = maxproduct(Y(:,k),(-XR(:,k))')
 % minproduct(Y(:,k),(-XR(:,k))')
 MR = minproduct(Y(:,k),(-XR(:,k))')
 
 % Se cumple WR == MR
 
 % WR-Wxy contiene algun cero en todas las filas? Tma 2, pg.9
 WR-Wxy
%      0     3    -1
%     -1     0    -1
%     -1     3    -1
% No cumple

 % Mxy-MR contiene algun cero en todas las filas? Tma 2, pg.9
 Mxy-MR
%      1     0     4
%      4     0     6
%      1     0     5
% Si cumple?

 % Tratamos de recuperar Y

% Y = maxproduct(Wxy,XR)?
  maxproduct(Wxy,XR)
  
%      0    -1     1
%      1     0    -1
%      1     0     1
% Ninguno de los vectores coincide

% Y = minproduct(Mxy,XR)?
  minproduct(Mxy,XR)

%      1     0     0
%      1     0    -2
%      1     0     0
% Unicamente ha recuperado/recordado el tercer vector
  
% nlfilter(A,[],funcion)
 

% Ejemplo 2. pg.10
  Wxy = mem_erosiva(X,Y);
%     -1     0     0
%     -2     1    -2
%      0     0     0
 Mxy = mem_dilatativa(X,Y); 
%      0     3     3
%      1     1     3
%      0     3     4
 
W = maxproduct(Y(:,2),-(X(:,2)'))

%     -1     1     3
%     -1     1     3
%      0     2     4

Wxy-W
%      0    -1    -3
%     -1     0    -5
%      0    -2    -4

% Ejemplo 2. pg.10 ec.35 son cero las posiciones (i,j): (1,1),(2,2),(3,1)

M = minproduct(Y(:,2),(-X(:,2))')
%     -1     1     3
%     -1     1     3
%      0     2     4

Mxy-M

%      1     2     0
%      2     0     0
%      0     1     0

% Hay mas ceros de los que aparecen en el ejemplo. No importa?

% Ejemplo 3. pg.11
% X = [x1,x2,x3]
 X = [ -5  0  0 ;
       -6 -4  0 ;
       -1 -1  0 ];
   
 % Y = [y1,y2,y3] 
 Y = [ -1  2  5 ;
        1  5  7 ;
       -3 -1  0 ]; 
   
   
  XR1 =  [-4;-8;-1];
  
  % memoria erosiva Wxy
 Wxy = mem_erosiva(X,Y);% ec.46 pg.12
%      2     5     0
%      5     7     2
%     -1     0    -2
 maxproduct(Wxy,XR1)
 
 % lo cumple aunque no tengo claro como demostrarlo para cada elemto con tanto max min

 % AUTO-ASSOCIATIVE MORPHOLOGICAL MEMORIES pg.12

 % X = Y
 
 % Tma.4 pg.14
 % El maxproduct de la memoria erosivaXX con X devuelve X
 % maxproduct(Wxx,X) = X
 % minproduct(Mxx,X) = X
 
 % Tma.5 pg.15
 
 



  