% pru_morfo.m

n = 128;
m = 128;
k = 5;

A = round(5*rand(n,k));
B = round(5*rand(k,m));
D = round(5*rand(k,m));
C1 = maxproduct(A,B);
C2 = minproduct(A,B);


% Auto-associative morphological memories
Wxy = mem_erosiva(A,A);
Mxy = mem_dilatativa(A,A);

C1 = maxproduct(Wxy,A);
C2 = minproduct(Mxy,A);

 sum(sum(C1==A)) == 5*128 % si es 1 son iguales, esto para comprobar matrices
 sum(sum(C2==A)) == 5*128
 
 % para comprobar que un vector es morfologicamente dependiente
 
 xr = round(5*rand(n,1)); % vector ruido
 recuerdo_xr = maxproduct(Wxy,xr);
 
 
 [v,i,j]= intersect(Wxy',recuerdo_xr','rows') % vacio -> independiente morfologicamente
 
 [v,i,j]= intersect(Wxy',Wxy(:,1)','rows') % devuelve el vector y los indices, dependiente
 
 xrand = A(:,1)+round(rand(n,1)); % añadimos ruido al primer vector
 
  recuerdo_xr = maxproduct(Wxy,xrand);
  sum(xrand >=recuerdo_xr) %  Tma 3. pg.11, ec.47 pg.12
  % 65 elementos cumplen
 [v,i,j]= intersect(Wxy',recuerdo_xr','rows') % vacio -> independiente morfologicamente
 
 sum(A(:,1) >=recuerdo_xr) %  Tma 3. pg.11, ec.47 pg.12
 % 2 elementos cumplen
 [v,i,j]= intersect(A',recuerdo_xr','rows') % vacio -> independiente morfologicamente
 
 
 
 recuerdo_xr = minproduct(Mxy,xrand);
 sum(xrand <=recuerdo_xr)
 % 79 elementos cumplen
 [v,i,j]= intersect(Mxy',recuerdo_xr','rows') % vacio -> independiente morfologicamente
 
 sum(A(:,1) <=recuerdo_xr) %  Tma 3. pg.11, ec.47 pg.12
 % 128 elementos cumplen,
 % claro hemos creado el vector sumandole el ruido !!!! dilative change
 [v,i,j]= intersect(A',recuerdo_xr','rows') % vacio -> independiente morfologicamente
 
 % Tma. 5 pg.15
 
 recuerdo_v = maxproduct(Wxy,xrand); % v
 recuerdo_u = minproduct(Mxy,xrand); % u
 
 recuerdo_v2 = maxproduct(Wxy,recuerdo_v); % v
 (sum(recuerdo_v2 ==recuerdo_v) == 128) % si es 1 son iguales
 recuerdo_u2 = minproduct(Mxy,recuerdo_u); % u
 (sum(recuerdo_u2 ==recuerdo_u) == 128) % si es 1 son iguales
 
 % Cumple el teorema
 
 
 % PERFECT RECALL CONDITIONS FOR DISTORTED PATTERNS pg.17
 % M1 & W1 memories
 % M1 se construye de manera que pueda asociar versiones aleatoriamente
 % corruptas del elemento x_k con un subpatron z_k que consta de unos pocos
 % valores patron seleccionados de x_k. El patron z_k representa una version
 % erosionada especial de x_k
 % La memoria W1 se define como una memoria asociativa que asocia a cada
 % entrada zk el patron yk.
 % Calculando el maxproduct de W1 con el resultado del minproduct de W1 y
 % xk
 % maxproduct(W1,minproduct(M1,x_k)) = y_k
 % para el patron corrupto, xr_k, se cumpliria igualmente
 %  maxproduct(W1,minproduct(M1,xr_k)) = y_k
 
 
 % Definicion de KERNEL pg.18
 % Z es un kernel de (X,Y)
 % si y solo si se cumplen las dos condiciones siguientes:
 % 1. Z es igual al minproduct de Mzz y X: minproduct(Mzz,X) = Z
 % 2. Y esiigual al maxproduct de Wzy y Z: maxproduct(Wzy,Z) = Y
 % input -> Mzz -> Wzy -> output
 
 
 
 % Tma.6 pg.18
 % Si Z es un kernel para (X,Y) entonces Z<=X
 
 % Ejemplo 4
 % El conjunto Z es un kernel para los vectores del ej.1
 Z = [ 0  0  0 ;
       0 -2 -3 ;
      -2 -4 -2 ]; 
 
  % Ejemplo 1, pg. 7
 
 k = 3; % 3 vectores
 n = 3; % dim 3x1, x
 m = 3; % dim 3x1, y
 
 % X = [x1,x2,x3]
 X = [ 0  0  0 ;
       0 -2 -3 ;
       0 -4  0 ]; 
   
 % Y = [y1,y2,y3] 
 Y = [ 0 -1  0 ;
       1 -1 -2 ;
       0  0  0 ]; 

 Wxy = mem_erosiva(X,Y);
%     -1     0     0
%     -2     1    -2
%      0     0     0
 Mxy = mem_dilatativa(X,Y); 
%      0     3     3
%      1     1     3
%      0     3     4


Mzz = mem_dilatativa(Z,Z); 
%      0     3     4
%      0     0     2
%     -2     1     0
Wzy = mem_erosiva(Z,Y);
%     -1     0     2
%     -2     1     0
%      0     0     2
 
% Condiciones para ser el kernel para (X,Y)
% 1. minproduct(Mzz,X) = Z
 Z1 = minproduct(Mzz,X)
 sum(sum(Z1 == Z)) ==9 % = 1, cumple
% 2. maxproduct(Wzy,Z) = Y
 Y1 = maxproduct(Wzy,Z)
  sum(sum(Y1 == Y)) ==9 % = 1, cumple
  
  % Z<=X
  sum(sum(Z <= X)) ==9 % = 1, cumple
  
  % Kernels apropiados? (Proper kernels) pg. 19
  % Si para todo k, se cumple z_k distinto de x_k entonces Z es un kernel
  % apropiado
  
  
  % Tma. 7 pg.19
  
 
 
 
 
 
 
 