% With this code we have obtained the results shown in the article
% "Learning Parsimonious Dendritic Classifiers" 
% submitted for publication in Neurocomputing.
% Example of execution on the SYNTH dataset
%
% Copyright 2011 ::  Manuel Graa & Ana I. Gonzalez
%
 

clc
clear all
reset(RandStream.getDefaultStream);  % Identical repetition of runs


%%    Load dataset
clave='synth_';     % name used in saved files
load synth.tr
synth	= synth(randperm(size(synth,1)),:);
X=synth(:,1:2);
t=synth(:,3);       % t in {0,1}
load synth.te
Xtest=synth(:,1:2);
ttest=synth(:,3);   % t in {0,1}

[N,d] = size(X);
t	  = logical(t);    
Nt    = size(Xtest,1);

% Normalizar
value_mean = mean(X);
value_std  = std(X);
value_std(value_std==0) = 1; % not to scale those with zero variance
X     = (X-ones(N,1)*value_mean)./(ones(N,1)*value_std);
Xtest = (Xtest-ones(Nt,1)*value_mean)./(ones(Nt,1)*value_std);

% Subset of inputs of class 1
X_c1  = X(t,:);  
N_c1  = size(X_c1,1);

% Definition of sigmoid and dirac function
sigmoid=inline('1./(1+exp(-x))');
dirac=inline('x==0');



%%     Initialization               

maxIts  = 5;  % Maximum number of iterations
Noaccept_butinchain = 1; % Don't accepted as new conf., but added to the chain  OPTAR POR UN METODO U OTRO

% Spike & Slab parameters
C=0.5;  
logC=log(C);
log1_C=log(1-C);

% Set up (u)pper and (l)ower hyperpameters
MAX_ALPHA = 1    % alpha params lower than this, then pi_params to inf

initAlpha = N_c1*d;
alpha_l = initAlpha*ones(N_c1,d);
alpha_u = initAlpha*ones(N_c1,d);

% Set up  (u)pper and (l)ower parameters
pi_u_params = zeros(N_c1,d);    % in {0, inf};  
pi_l_params = zeros(N_c1,d);
 
eps_l_params = zeros(N_c1,d);  % epsilon_params in R+
eps_u_params = zeros(N_c1,d);  

pe_params = ones(N_c1,1);    % in {-1, 1};
pi_params = zeros(N_c1,1);   % in {0, -inf};


%% Prune parameters and hyperparameters
% initially to match formats in all iterations,  transformed into vector    
useful_l  = (alpha_l > 0);     % All are okey
useful_u  = (alpha_u > 0);     
Nused_l   = sum(sum(useful_l))   
Nused_u   = sum(sum(useful_u))   
ind_l_used  = find(useful_l==1);
ind_u_used  = find(useful_u==1);

alpha_l_used = alpha_l(useful_l); 
alpha_u_used = alpha_u(useful_u); 
pi_u_params_used = pi_u_params(useful_u); 
pi_l_params_used = pi_l_params(useful_l); 
eps_l_params_used = eps_l_params(useful_l);
eps_u_params_used = eps_u_params(useful_u);

%
%% The main loop
% 
for iter=1:maxIts
    
  %% Compute response of dendritics
    tau=zeros(N,1);
    upper_limit = X_c1(useful_u) + eps_u_params_used + pi_u_params_used;
    lower_limit = X_c1(useful_l) - eps_l_params_used - pi_l_params_used;
    for i=1:N
        % Calculate box-lattice-based kernel function
        aux=ones(N_c1,1)*X(i,:);
        diff_lower = aux(useful_l) - lower_limit;
        diff_upper = upper_limit - aux(useful_u);
        matriz_u=zeros(N_c1,d);  % convert to matrix format
        matriz_u(ind_u_used)=diff_upper;
        matriz_l=zeros(N_c1,d);
        matriz_l(ind_l_used)=diff_lower;
        lambda=min( min(matriz_u,matriz_l), [], 2);
        % Calculate dendritic neuron activation
        tau(i,1) = max(lambda.*pe_params+pi_params); 
    end
 
   
    y = sigmoid(tau);
    likelihood_old	= (sum(log(y(t))) + sum(log(1-y(~t))));
    
    %Spike & slab prior:  1st over all parameters
    regulariser_old	= - sum ( log(alpha_l_used) + eps_l_params_used.*(1./alpha_l_used)) + ... 
                      - sum ( log(alpha_u_used) + eps_u_params_used.*(1./alpha_u_used)) + ...
                      sum ( dirac(pi_l_params_used)*logC + (1-dirac(pi_l_params_used))*log1_C) + ...
                      sum ( dirac(pi_u_params_used)*logC + (1-dirac(pi_u_params_used))*log1_C) ;

    energy_old	= likelihood_old + regulariser_old;


  
  
    %% Monte Carlo method (max)  
    
    %% Initialization MC
    ini_temp = 1;     % Initial temperature
    fin_temp = 1e-3;  % Final temperature  (higher value, slower annealing)     
    
    maxsimu = (Nused_l+Nused_u)*500;  % simulations based on number of parameters
    
    sum_eps_l_params  = eps_l_params_used;      % sum of elements (for mean computation)
    sum_eps_u_params  = eps_u_params_used;      % sum of elements (for mean computation)

    energy_sequence = [];     % to plot the energy evolution
    energy_sequence(1,:) = [likelihood_old regulariser_old];   
    
    % precomputation of a fixed regulariser part
    regulariser_new_B = sum ( dirac(pi_l_params_used)*logC + (1-dirac(pi_l_params_used))*log1_C) + ...
                        sum ( dirac(pi_u_params_used)*logC + (1-dirac(pi_u_params_used))*log1_C) ;

        
   %% Generate Markov Chain (sample)
    for ksimu=2:maxsimu
        
        new_eps_l_params = eps_l_params_used;  
        new_eps_u_params = eps_u_params_used;  
        
        %% Generate new candidate configuration 
        accepted=0;
        if rand>0.5  
           inewparam = floor(rand*Nused_u+1);  
           new_eps_u_params(inewparam) = max( 0, new_eps_u_params(inewparam)+randn*0.01); % no permitir valores negativos
        else   
           inewparam = floor(rand*Nused_l+1);  
           new_eps_l_params(inewparam) = max( 0, new_eps_l_params(inewparam)+randn*0.01); % no permitir valores negativos
        end
         

         
        %% Compute response of dendritics 
        tau=zeros(N,1);
        upper_limit = X_c1(useful_u) + new_eps_u_params + pi_u_params_used;
        lower_limit = X_c1(useful_l) - new_eps_l_params - pi_l_params_used;
        for i=1:N
            % Calculate box-lattice-based kernel function
            aux=ones(N_c1,1)*X(i,:);
            diff_lower = aux(useful_l) - lower_limit;
            diff_upper = upper_limit - aux(useful_u);
            matriz_u=zeros(N_c1,d);  % convert to matrix format
            matriz_u(ind_u_used)=diff_upper;
            matriz_l=zeros(N_c1,d);
            matriz_l(ind_l_used)=diff_lower;
            lambda=min( min(matriz_u,matriz_l), [], 2);
            % Calculate dendritic neuron activation
            tau(i,1) = max(lambda.*pe_params+pi_params); 
        end
        y = sigmoid(tau);
        likelihood_new	= (sum(log(y(t))) + sum(log(1-y(~t))));
  
    %   Spike & slab prior:
        aux_l_reg_A = log(alpha_l_used) + new_eps_l_params.*(1./alpha_l_used);
        aux_u_reg_A = log(alpha_u_used) + new_eps_u_params.*(1./alpha_u_used);
        
        regulariser_new_A = - sum ( aux_l_reg_A(pi_l_params_used==0) ) + ... 
                            - sum ( aux_u_reg_A(pi_u_params_used==0)  ) ;
                          
        regulariser_new	= regulariser_new_A + regulariser_new_B;

        energy_new	= likelihood_new + regulariser_new;

        
        %% Accept new configuration?
        temp = (fin_temp/ini_temp)^(ksimu/maxsimu);  
        incr_energy = energy_new - energy_old;
        if incr_energy > 0 % we accepted
            accepted = 1;
        else      % we accepted with certain probability
            probaccept = exp(incr_energy/temp);    
            if probaccept > rand
                accepted = 1;
            end
        end
   
        if accepted   
            eps_l_params_used = new_eps_l_params ;  
            eps_u_params_used = new_eps_u_params ;  
            energy_old = energy_new;
            likelihood_old = likelihood_new;
            regulariser_old = regulariser_new;
        end
        %Compute on mean value, although new configuration is not accepted
        sum_eps_l_params  = sum_eps_l_params  + eps_l_params_used;      
        sum_eps_u_params  = sum_eps_u_params  + eps_u_params_used;      
       
        energy_sequence(ksimu,:) = [likelihood_old regulariser_old];   % to debug
        
        
    end   % end of MC
  
    % Save last configuration in pi_params
    eps_l_params(useful_l) = eps_l_params_used;  
    eps_u_params(useful_u) = eps_u_params_used;  

       

   
   %%     Update alpha_params                          
   % parameters mean over all generated configurations
    mean_eps_l_params = sum_eps_l_params/maxsimu;
    mean_eps_u_params = sum_eps_u_params/maxsimu;

    alpha_l(useful_l) = 1./mean_eps_l_params;
    alpha_u(useful_u) = 1./mean_eps_u_params;

   
   
   %%      Prune pi_x_params    
    % Determine relevant parameters
    useful_l  = (alpha_l >=  MAX_ALPHA);     
    useful_u  = (alpha_u >=  MAX_ALPHA);    
    Nused_l   = sum(sum(useful_l))   
    Nused_u   = sum(sum(useful_u))   
    ind_l_used  = find(useful_l==1);
    ind_u_used  = find(useful_u==1);
    
    % prune of no relevant parameters
    pi_l_params(~useful_l) = inf;       
    pi_u_params(~useful_u) = inf; 
    eps_l_params(~useful_l) = 0;
    eps_u_params(~useful_u) = 0;

    % select current relevant parameters
    alpha_l_used = alpha_l(useful_l);   
    alpha_u_used = alpha_u(useful_u);   
    pi_u_params_used = pi_u_params(useful_u); 
    pi_l_params_used = pi_l_params(useful_l); 
    eps_l_params_used = eps_l_params(useful_l);
    eps_u_params_used = eps_u_params(useful_u);

    
   %%      Update C parameter         
    C = ( Nused_u + Nused_l ) / ( 2*N_c1*d ) - 0.00001   % to avoid prior = NaN
    logC=log(C);
    log1_C=log(1-C);

    
    %% Visualize intermediate results
    figure (1)
    clf
    hold on
    plot(energy_sequence(:,1) + energy_sequence(:,2))
    title('energy')
    drawnow
    
    %% Compute response of dendritics
    tau=zeros(N,1);
    upper_limit = X_c1(useful_u) + eps_u_params_used + pi_u_params_used;
    lower_limit = X_c1(useful_l) - eps_l_params_used - pi_l_params_used;
    for i=1:N
        % Calculate box-lattice-based kernel function
        aux=ones(N_c1,1)*X(i,:);
        diff_lower = aux(useful_l) - lower_limit;
        diff_upper = upper_limit - aux(useful_u);
        matriz_u=zeros(N_c1,d);  % convert to matrix format
        matriz_u(ind_u_used)=diff_upper;
        matriz_l=zeros(N_c1,d);
        matriz_l(ind_l_used)=diff_lower;
        lambda=min( min(matriz_u,matriz_l), [], 2);
        % Calculate dendritic neuron activation
        tau(i,1) = max(lambda.*pe_params+pi_params); 
    end
    y = sigmoid(tau);
    ResulClassif = round(y);     
    accuracy_train = 1 - mean((ResulClassif-t).^2)
       
  
  if (Nused_u + Nused_l)<2
      break
  end
     
  
end    %main loop





%%       T e s t                       

%% Compute response of dendritics
tau=zeros(Nt,1);
upper_limit = X_c1(useful_u) + eps_u_params_used + pi_u_params_used;
lower_limit = X_c1(useful_l) - eps_l_params_used - pi_l_params_used;
for i=1:Nt
    % Calculate box-lattice-based kernel function
    aux=ones(N_c1,1)*Xtest(i,:);
    diff_lower = aux(useful_l) - lower_limit ;
    diff_upper = upper_limit - aux(useful_u) ;
    matriz_u=zeros(N_c1,d); % convert to matrix format
    matriz_u(ind_u_used)=diff_upper;
    matriz_l=zeros(N_c1,d);
    matriz_l(ind_l_used)=diff_lower;
    lambda=min( min(matriz_u,matriz_l), [], 2);
    % Calculate dendritic neuron activation
    tau(i,1) = max(lambda.*pe_params+pi_params); 

end
y = sigmoid(tau);
ResulClassif = round(y);  

%% Calculate confusion matrix
TP = sum((ttest==1) & (ResulClassif==1)); % true positive
TN = sum((ttest==0) & (ResulClassif==0)); % true negative
FP = sum((ttest==0) & (ResulClassif==1)); % false positive
FN = sum((ttest==1) & (ResulClassif==0)); % false negative

precision   = TP/(TP+FP);
sensitivity = TP/(TP+FN);
specificity = TN/(TN+FP);
accuracy    = (TP+TN)/Nt;

%% Display results
disp(['accuracy train result:'])
disp(accuracy_train)
disp(['test results:'])
disp(['  precision ', 'sensitivity  ', 'specificity  ', 'accuracy'] )      
disp([precision sensitivity specificity accuracy])


%% Save results
eval (['save Resul_SBL-SLKN_' clave '  pi_l_params pi_u_params eps_l_params eps_u_params '  ... 
'pe_params pi_params precision sensitivity specificity accuracy accuracy_train ' ...
'maxsimu fin_temp energy_sequence Nused_l Nused_u C alpha_l alpha_u ' ])

