% By Ramón Morneo jiménez
% natafresa@gmail.com
% Computational Intelligence Group
% http://www.ehu.es/ccwintco

% please,if you are going to use this code in some job for publication, refer it as:
% @INCOLLECTION{corchado_hybrid_2010,
%  author = {Emilio Corchado and Manuel Graña Romay and Alexandre Manhaes Savio
%	and Ramón Moreno and José {López-Guede} and Alicia {d’Anjou}},
%  title = {Hybrid Color Space Transformation to Visualize Color Constancy},
%  booktitle = {Hybrid Artificial Intelligence Systems},
%  publisher = {Springer Berlin / Heidelberg},
%  year = {2010},
%  volume = {6077},
%  series = {Lecture Notes in Computer Science},
%  pages = {241--247},
%  url = {http://dx.doi.org/10.1007/978-3-642-13803-4_30}
%}


% specular free transform

function IR = SF3(I)

disp('This can take a while..');

[a b c] = size(I);
IR = I; %swet default value
IN = zeros(a,b); % matriz de intensidades

Lsp = [255 255 255]; 
th = angulo(Lsp',[255 0 0]');

for f = 1:a
  for c = 1:b
    px = I(f,c,:);
    IN(f,c) = angulo(px(:),Lsp');
    
  end
end

hsv = rgb2hsv(I);
hsv(:,:,3) = IN/th;
IR=hsv2rgb(hsv);
IR = uint8(IR *255);

% angle between two lines
function ang = angulo(P,Q)
  P = double (P);
  Q = double(Q);
  
  num = P' * Q;
  den = sqrt(P'*P)*sqrt(Q'*Q);
  
  if den == 0
    ang = NaN;
  else
    ang = acos(num/den);
  end
