<?php
// Configuration Variables

// Directorio raíz de la instalación
$GLOBALS["installdir"] = "/users/zaindegi";

// language: (en, de, es, fr, nl, ru)
$GLOBALS["availablelanguages"] = array( "eu" => "eu-ES", "es" => "es-ES", "en" => "en-US" );
$GLOBALS["language"] = "es";

// URL del script con ssl (para autentificacion LDAP)
if (isset($_SERVER["HTTP_HOST"])) {
    $server=$_SERVER["HTTP_HOST"];
} else {
    $server=rtrim(shell_exec("/bin/hostname"));
}
$GLOBALS["urlssl"] = "https://$server/zaindegi/index.php";

// the home directory for the filemanager: (use '/', not '\' or '\\', no trailing '/')
$GLOBALS["home_dir"] = $GLOBALS["installdir"]."/files";

// Subredes autorizadas a la descarga
$GLOBALS["subredes"] = array ( '10.*', '158.227.*', '2001:720:1410:.*');

// Espacio máximo a ocupar por todos los archivos en bytes (21474836480 => 20 GB)
$GLOBALS["quota"] = 21474836480;

// Tamaño máximo del fichero a subir (para mensaje informativo)
$GLOBALS["maxfilesize"] = 200;

// BD para password de los ficheros
$GLOBALS["dbfile"] = $GLOBALS["installdir"]."/db/consigna.db";

// Fichero de log
$GLOBALS["logfile"] = $GLOBALS["installdir"]."/logs/consigna.log";

//Antivirus
//Dejar esta variable a "" para que no escanee
$GLOBALS["antivirus"] = "";

// Usar autenticación por LDAP
$GLOBALS["usarldap"] = true;

// Datos para LDAP
$GLOBALS["hostldap"] = "ldaps://ldap.ehu.es";
$GLOBALS["ldapversion"] = 3;

// Logintud máxima de las etiquetas
$GLOBALS["labellength"] = 20;

// CONFIGURACION GARBAGE COLLECTOR
// Dias para mantener los ficheros antes de ser borrados (garbage-collector)
$GLOBALS["dias"] = 3;

// Esperar tiempo aleatorio (max 1 min.) antes de ejecutar garbage-collector 
// para minimizar problemas de ejecución simultánea.
$GLOBALS["randomwait"] = true;

// Fichero de lock. Dejar vacio para no usar.
$GLOBALS["filelock"] = $GLOBALS["installdir"]."/lock/garbage-collector.lock";

// Nombre usuario anonimo
$GLOBALS["anonymous"] = "anonymous";

// Zona horaria
date_default_timezone_set("Europe/Madrid");

// Número de items a partir de los cuales se mostrará la toolbar inferior
$GLOBALS["num_items_bottom_toolbar"] = 30;
