<?php
/*
 * Módulo de autenticación LDAP para consigna
 *
 *  Daniel García Moreno <danigm@us.es>
 *  Jorge López Pérez <jorgelp@us.es>
 *
 *   noviembre de 2007
 */
function autenticaLDAP()
{
    if (!isset($_POST['usuario']) || !isset($_POST['contrasen'])) {
        return false;
    } else {
        $usuario = $_POST['usuario'];
        $pass = $_POST['contrasen'];
    }
    $ds=@ldap_connect($GLOBALS["hostldap"]);
    if ($ds) {
        ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, $GLOBALS["ldapversion"]);
        if (@ldap_bind($ds, "uid=$usuario,ou=people,dc=ehu,dc=es", $pass)) {
            loggear("ldap: Usuario $usuario ha iniciado sesion");
            $necesitamos=array('cn');
            $filtro="uid=$usuario";
            $sr=@ldap_search($ds, "dc=ehu,dc=es", $filtro, $necesitamos);
            if (!$sr) {
                loggear("ldap: Fallo de busqueda");
                show_error($GLOBALS["error_msg"]["errorldap"]);
                ldap_unbind($ds);
            } else {
                $info=@ldap_get_entries($ds, $sr);
                ldap_unbind($ds);
                if ($info['count'] != 1) {
                    loggear("ldap: No se ha podido encontrar al usuario");
                    show_error($GLOBALS["error_msg"]["errorldap"]);
                } else {
                    $nombrecompleto=iconv("utf-8", "iso8859-1", $info[0]['cn'][0]);
                    $_SESSION['usuarioldap'] = $usuario;
                    $_SESSION['nombreldap'] = $nombrecompleto;
                    return true;
                }
            }
        } else {
            loggear("ldap: Inicio sesion no valido para $usuario");
            show_error($GLOBALS["error_msg"]["errorusuarioldap"]);
        }
    } else {
        loggear("ldap: No ha sido posible conectarse al servidor LDAP ".$GLOBALS["ldapserver"]);
        show_error($GLOBALS["error_msg"]["errorldap"]);
    }
    return false;
}

/**
 * Realiza logout de la sesión del usuario autenticado previamente
 * en LDAP
 */
function logoutLDAP()
{
    // Simplemente borramos la variable de sesión
    loggear("ldap: Usuario \"".$_SESSION['usuarioldap']."\" finaliza sesion");
    $_SESSION['usuarioldap'] = $GLOBALS["anonymous"];
    $_SESSION['nombreldap'] = "";
}
