<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is fun_del.php, released on 2003-03-31.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    File-Delete Functions
    
    Have Fun...
------------------------------------------------------------------------------*/
//------------------------------------------------------------------------------
function del_items($dir)
{
    // delete files/dirs
    $cnt=count($_POST["selitems"]);
    $err=false;
    
    // array para almacenar los ficheros con password
    $fileswithpassword= array ();
    // array para los ficheros que se van borrando
    $filesborrados= array();

    // delete files & check for errors
    for ($i=0; $i<$cnt; ++$i) {
        $items[$i] = stripslashes($_POST["selitems"][$i]);
        if (!@file_exists(get_abs_item($dir, $items[$i]))) {
            $error[$i]=$GLOBALS["error_msg"]["itemexist"];
            $err=true;
            continue;
        }
        $abs_item=get_abs_item($dir, $items[$i]);
        // Ficheros con password
        $id=dba_open($GLOBALS["dbfile"], "w", "db4");
        if ($id > 0) {
            // Ahora hemos de comprobar si el password es vacio o no
            if (dba_exists($abs_item, $id)) {
                $dbline=dba_fetch($abs_item, $id);
                if (($pos=strpos($dbline, "/")) && (strlen($dbline) > ($pos+1))) {
                    array_push($fileswithpassword, $items[$i]);
                    $error[$i]=null;
                    dba_close($id);
                    continue;
                }
            }
            dba_close($id);
        }
        // Delete
        $ok=unlink($abs_item);
        if (!$ok) {
            $error[$i]=$GLOBALS["error_msg"]["delitem"];
            $err=true;
            continue;
        } else {
            loggear("REMOVE: $items[$i]");
            $num=num_files($GLOBALS["home_dir"]);
            $usage=dir_size($GLOBALS["home_dir"]);
            $percentage=sprintf("%.2f", $usage*100/$GLOBALS["quota"]);
            loggear("DISK USAGE: $num files / $usage bytes ($percentage%)");
            array_push($filesborrados, $items[$i]);
            // Actualizamos la BD
            $id=dba_open($GLOBALS["dbfile"], "w", "db4");
            if ($id > 0) {
                dba_delete($abs_item, $id);
                dba_close($id);
            }
        }
        $error[$i]=null;
    }
    if ($err) {
        // there were errors
        $err_msg="";
        for ($i=0; $i<$cnt; ++$i) {
            if ($error[$i]==null) {
                continue;
            }
            $err_msg .= $items[$i]." : ".$error[$i]."<br/>\n";
        }
        show_error($err_msg);
    }
    // Mostrar informe sobre resultados y pedir password que sean necesarias.
    // $filesborrados $fileswithpassword
    if (count($fileswithpassword)>0) {
        show_header();
        echo "<div class=\"cuerpomensaje\">\n";
        echo "<form method=\"POST\" action=\"";
        echo make_link("check_del_password", $dir);
        echo "\">\n<INPUT type=\"hidden\" name=\"confirm\" value=\"true\">\n";
        if (count($filesborrados)>0) {
            echo "<h2>".$GLOBALS["messages"]["filedeleted"]."</h2>\n";
            echo "<ul class=\"files\">\n";
            while (count($filesborrados)>0) {
                $file=array_pop($filesborrados);
                echo "<li class=\"files\"><IMG SRC=\"images/_info.gif\" ALT=\"\">&nbsp;$file</TD></TR>\n";
            }
            echo "</ul>\n";
        }
        echo "<h2>".$GLOBALS["messages"]["passwordrequired"]."</h2>\n";
        echo "<ul class=\"files\">\n";
        while (count($fileswithpassword)>0) {
            $file=array_pop($fileswithpassword);
            echo "<li><IMG SRC=\"images/_info.gif\" ALT=\"\">\n";
            echo "<INPUT type=\"hidden\" name=\"selitems[]\" value=\"$file\">&nbsp;$file&nbsp;\n";
            echo "<INPUT type=\"password\" name=\"password[]\" size=\"20\"></li>\n";
        }
        echo "</ul>\n<ul class=\"botones\"><li><INPUT type=\"submit\" value=\"".$GLOBALS["messages"]["btnaccept"];
        echo "\"></li>\n<li><input type=\"button\" value=\"".$GLOBALS["messages"]["btncancel"];
        echo "\" onClick=\"javascript:location='".make_link("list", $dir, null)."';\">\n</li></ul></FORM>\n";
        echo "</div>\n";
    } else {
        header("Location: ".make_link("list", $dir, null));
    }
}
