<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is fun_down.php, released on 2003-01-25.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    File-Download Functions
    
    Have Fun...
------------------------------------------------------------------------------*/

// Funcion para chequear si la IP proviene del rango de IPs autorizadas 
function check_ip($ip)
{
    foreach ($GLOBALS["subredes"] as $valor) {
        if (preg_match("/^$valor/i", $ip)) {
            return true;
        }
    }
    return false;
}

/**
 * Devuelve TRUE si el usuario tiene permiso para descargar el fichero
 * $item, FALSE e.o.c.
 */
function tienePermiso($dir, $item)
{
    // Si esta autenticado, siempre tendra acceso.
    if (sessionLDAP()) {
        return true;
    }

    $id=dba_open($GLOBALS["dbfile"], "r", "db4");
    if ($id > 0) {
        $abs_item = get_abs_item($dir, $item);
        if (dba_exists($abs_item, $id)) {
            $dbline=dba_fetch($abs_item, $id);
            dba_close($id);
            if (strpos($dbline, "/")) {
                $campos = explode("/", $dbline);

                // Lo subio un usuario autenticado?
                if (!empty($campos[3]) && ($campos[3] != $GLOBALS["anonymous"])) {
                    return true;
                }

                // Hacer la comprobacion de IP
                $ip=$_SERVER["REMOTE_ADDR"];
                if (check_ip($campos[0]) || check_ip($ip)) {
                    return true;
                }
            }
        }
    }
    return false;
}

function download_item($dir, $item)
{
    // download file
    if (!get_is_file($dir, $item)) {
        show_error($item.": ".$GLOBALS["error_msg"]["fileexist"]);
        return;
    }
   
    // Comprobacion de las IPs
    if (!tienePermiso($dir, $item)) {
        loggear("DOWNLOAD NOT AUTHORIZED: File $item");
        show_form_error($GLOBALS["error_msg"]["unauthorizeddownload"]);
        return;
    }

    $abs_item = get_abs_item($dir, $item);
    // Comprobar si el archivo tiene password para solicitarlo
    $id=dba_open($GLOBALS["dbfile"], "r", "db4");
    if ($id > 0) {
        if (dba_exists($abs_item, $id)) {
            $dbline=dba_fetch($abs_item, $id);
            if (strpos($dbline, "/")) {
                $campos = explode("/", $dbline);
            }
            // Pedir password
            if (isset($_POST["confirm"]) && $_POST["confirm"]=="true") {
                $password=$_POST['password'];
            } else {
                $err=$GLOBALS["messages"]["passwordrequired"];
                show_form($err, $dir, $item);
                return;
            }
            if ($campos[1] != $password) {
                $err=$GLOBALS["error_msg"]["passwordincorrect"];
                loggear("ERROR DOWNLOAD: Password incorrect $password for $item");
                show_form($err, $dir, $item);
            } else {
                // Hacemos el download
                // El password es valido
                dba_close($id);
                if (isset($_POST['confirm2']) && $_POST["confirm2"]=="true") {
                    loggear("DOWNLOAD: $item (".@filesize($abs_item)." bytes)");
                    make_download($dir, $item);
                } else {
                    show_ok_form($dir, $item, $password);
                }
            }
        } else {
            // dba_exists
            dba_close($id);
            loggear("ERROR DOWNLOAD: File $dir/$item not in BD");
            show_form_error($GLOBALS["error_msg"]["miscnofunc"]);
        }
    } else {
        // dba_open
        loggear("ERROR DOWNLOAD: Cannot open BD file");
        show_form_error($GLOBALS["error_msg"]["miscnofunc"]);
    }
}

function make_download($dir, $item)
{
    if (!get_is_file($dir, $item)) {
        show_error($item.": ".$GLOBALS["error_msg"]["fileexist"]);
    }
    $abs_item = get_abs_item($dir, $item);
    $browser=id_browser();
    header('Content-Type: '.(($browser=='IE' || $browser=='OPERA')?
        'application/octetstream':'application/octet-stream'));
    header('Expires: '.gmdate('D, d M Y H:i:s').' GMT');
    header('Content-Transfer-Encoding: binary');
    header('Content-Length: '.filesize($abs_item));
    if ($browser=='IE') {
        header('Content-Disposition: attachment; filename="'.$item.'"');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
    } else {
        header('Content-Disposition: attachment; filename="'.$item.'"');
        header('Cache-Control: no-cache, must-revalidate');
        header('Pragma: no-cache');
    }
    ob_clean();
    flush();
    @readfile($abs_item);
    exit;
}

function show_form($err, $dir, $item)
{
    show_header();
    echo "<div class=\"cuerpomensaje\">\n";
    echo "<h2>$err</h2>\n";
    echo "<form action=\"".make_link("download", $dir, $item)."\" method=\"post\">\n";
    echo "<INPUT type=\"hidden\" name=\"confirm\" value=\"true\"><ul class=\"files\">\n";
    echo "<li style=\"text-transform: capitalize;\">".$GLOBALS["messages"]["miscpassword"].": ";
    echo "<INPUT name=\"password\" type=\"password\" size=\"10\"></li>\n";
    echo "</ul>\n<ul class=\"botones\"><li><INPUT type=\"submit\" value=\"".$GLOBALS["messages"]["btnaccept"];
    echo "\"></li>\n<li><input type=\"button\" value=\"".$GLOBALS["messages"]["btncancel"];
    echo "\" onClick=\"javascript:history.back();\">\n</li></ul></form>\n</div>\n";
    show_footer();
    return;
}

function show_form_error($err)
{
    show_header();
    echo "<div class=\"error\">\n";
    echo "<h2>$err</h2>\n";
    echo "<ul class=\"botones\"><li><input type=\"button\" value=\"".$GLOBALS["messages"]["btnreturn"];
    echo "\" onClick=\"javascript:history.go(-1);\"></li>\n</ul>\n</div>\n";
    show_footer();
    return;
}

function show_ok_form($dir, $item, $pass)
{
    show_header();
    echo "<div class=\"clear\">\n</div>\n<div class=\"cuerpomensaje\">\n";
    echo "<h2>".$GLOBALS["messages"]["passwordcorrect"]."...</h2>\n";
    echo "<p>".$GLOBALS["messages"]["continuedownload"]."</p>\n";
    echo "<form action=\"".make_link("download", $dir, $item)."\" method=\"post\">\n";
    echo "<INPUT type=\"hidden\" name=\"confirm\" value=\"true\">\n";
    echo "<INPUT type=\"hidden\" name=\"confirm2\" value=\"true\">";
    echo "<INPUT type=\"hidden\" name=\"password\" value=\"$pass\">";
    echo "<ul class=\"botones\"><li><INPUT type=\"submit\" value=\"".$GLOBALS["messages"]["btncontinue"];
    echo "\"></li>\n<li><input type=\"button\" value=\"".$GLOBALS["messages"]["btnreturn"];
    echo "\" onClick=\"javascript:history.go(-2);\">\n</li></ul></form>\n</div>\n";
    show_footer();
    return;
}
