<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is fun_extra.php, released on 2003-03-31.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    (Extra) Functions
    
    Have Fun...
------------------------------------------------------------------------------*/
//------------------------------------------------------------------------------
// THESE ARE NUMEROUS HELPER FUNCTIONS FOR THE OTHER INCLUDE FILES
//------------------------------------------------------------------------------

// Funcion para obtener el usuario o anonimo en caso de que no se haya iniciado sesion
function obtener_usuario()
{
    if (sessionLDAP()) {
        return $_SESSION['usuarioldap'];
    } else {
        return $GLOBALS["anonymous"];
    }
}

// Funcion para loggear en $GLOBALS["logfile"]
function loggear($texto)
{
    $ip=$_SERVER["REMOTE_ADDR"];
    $fecha=date("[d/m/Y:H:i:s]");
    $usuario=obtener_usuario();
    error_log("$ip $fecha \"$usuario\" $texto\n", 3, $GLOBALS["logfile"]);
}

function make_link($_action, $_dir, $_item = null, $_order = null, $_srt = null, $_lang = null)
{
    // make link to next page
    if ($_action=="" || $_action==null) {
        $_action="list";
    }
    if ($_dir=="") {
        $_dir=null;
    }
    if ($_item=="") {
        $_item=null;
    }
    if ($_order==null) {
        $_order=$GLOBALS["order"];
    }
    if ($_srt==null) {
        $_srt=$GLOBALS["srt"];
    }
    if ($_lang==null) {
        $_lang=(isset($GLOBALS["lang"])?$GLOBALS["lang"]:null);
    }
    if ($_action=="autenticacionldap" || (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"]=="on")) {
        $link=$GLOBALS["urlssl"]."?action=".$_action;
    } else {
        $link=$_SERVER["PHP_SELF"]."?action=".$_action;
    }
    if ($_dir!=null) {
        $link.="&dir=".$_dir;
    }
    if ($_item!=null) {
        $link.="&item=".urlencode($_item);
    }
    if ($_order!=null) {
        $link.="&order=".$_order;
    }
    if ($_srt!=null) {
        $link.="&srt=".$_srt;
    }
    if ($_lang!=null) {
        $link.="&lang=".$_lang;
    }
    return $link;
}
//------------------------------------------------------------------------------
function get_abs_dir($dir)
{
    // get absolute path
    $abs_dir=$GLOBALS["home_dir"];
    if ($dir!="") {
        $abs_dir.="/".$dir;
    }
    return $abs_dir;
}
//------------------------------------------------------------------------------
function get_abs_item($dir, $item)
{
    // get absolute file+path
    return get_abs_dir($dir)."/".$item;
}
//------------------------------------------------------------------------------
function get_is_file($dir, $item)
{
    // can this file be edited?
    return @is_file(get_abs_item($dir, $item));
}
//------------------------------------------------------------------------------
function get_file_size($dir, $item)
{
    // file size
    return @filesize(get_abs_item($dir, $item));
}
//------------------------------------------------------------------------------
function parse_file_size($size)
{
    // parsed file size
    if ($size >= 1073741824) {
        $size = round($size / 1073741824 * 100) / 100 . " GB";
    } elseif ($size >= 1048576) {
        $size = round($size / 1048576 * 100) / 100 . " MB";
    } elseif ($size >= 1024) {
        $size = round($size / 1024 * 100) / 100 . " KB";
    } else {
        $size = $size . " Bytes";
    }
    if ($size<=0) {
        $size="-";
    }
    return $size;
}
//------------------------------------------------------------------------------
function get_file_date($dir, $item)
{
    // file date
    return @filemtime(get_abs_item($dir, $item));
}
//------------------------------------------------------------------------------
function parse_file_date($date)
{
    // parsed file date
    return @date($GLOBALS["date_fmt"], $date);
}
//-----------------------------------------------------------------------------
function get_mime_type($item, $query)
{
    // unknown file
    $mime_type    = $GLOBALS["mimes"]["file"];
    $image        = "file.gif";

    // get file's mimetype
    // mime_type
    foreach ($GLOBALS["used_mime_types"] as $mime) {
        list($desc, $img, $ext)    = $mime;
        if (preg_match("/$ext/i", $item)) {
            $mime_type    = $desc;
            $image        = $img;
        }
    }

    if ($query=="img") {
        return $image;
    } else {
        return $mime_type;
    }
}
//------------------------------------------------------------------------------
function get_max_file_size()
{
    // get php max_upload_file_size
    $max = get_cfg_var("upload_max_filesize");
    if (preg_match("/G$/i", $max)) {
        $max = substr($max, 0, -1);
        $max = round($max*1073741824);
    } elseif (preg_match("/M$/i", $max)) {
        $max = substr($max, 0, -1);
        $max = round($max*1048576);
    } elseif (preg_match("/K$/i", $max)) {
        $max = substr($max, 0, -1);
        $max = round($max*1024);
    }
    return $max;
}
//------------------------------------------------------------------------------
function id_browser()
{
    $browser=$_SERVER['HTTP_USER_AGENT'];
    if (preg_match('/Opera(\/| )([0-9].[0-9]{1,2})/', $browser)) {
        return 'OPERA';
    } elseif (preg_match('/MSIE ([0-9].[0-9]{1,2})/', $browser)) {
        return 'IE';
    } else {
        return 'OTHER';
    }
}
//------------------------------------------------------------------------------
// RETURNS THE TOTAL SIZE OF ALL FILES
// WITHIN A DIRECTORY AND SUBSEQUENT CHILD DIRECTORIES
// LIMITED TO DIRECTORIES AND FILES OWNED BY
// THE OPERATING USER (PHP/APACHE IN MOST CASES)
//
// RETURNS AN INT
//
function dir_size($DIR = false)
{
    // IF DIR IS TRUE AND IS A DIRECTORY
    $SIZE=0;
    if ($DIR && is_dir($DIR)) {
    // ADD TRAILING SLASH
        if (substr($DIR, -1) != "/") {
            $DIR .= "/";
        }
        // OPEN DIRECTORY
        if ($DIR_ID = opendir($DIR)) {
            // LOOP THROUGH CONTENTS OF DIR
            while (($ITEM = readdir($DIR_ID)) !== false) {
                // IF ITEM DOES NOT EQUAL "." AND ".."
                if ($ITEM != "." && $ITEM != "..") {
                    // IF ITEM IS A DIRECTORY
                    if (is_dir($DIR . $ITEM)) {
                        // CALL FUNCTION RECURSIVELY
                        $SIZE += dir_size($DIR . $ITEM);
                        // ELSE ITEM IS A FILE
                    } else {
                        // ADD SIZE OF FILE
                        $SIZE += filesize($DIR . $ITEM);
                    }
                }
            }
            // CLOSE DIRECTORY
            closedir($DIR_ID);
        }
    }
    // RETURN SIZE
    return $SIZE;
}
//------------------------------------------------------------------------------
//
// RETURNS AN INT
//
function num_files($DIR = false)
{
    // IF DIR IS TRUE AND IS A DIRECTORY
    $FILES=0;
    if ($DIR && is_dir($DIR)) {
        // ADD TRAILING SLASH
        if (substr($DIR, -1) != "/") {
            $DIR .= "/";
        }
        // OPEN DIRECTORY
        if ($DIR_ID = opendir($DIR)) {
            // LOOP THROUGH CONTENTS OF DIR
            while (($ITEM = readdir($DIR_ID)) !== false) {
                // IF ITEM DOES NOT EQUAL "." AND ".."
                if ($ITEM != "." && $ITEM != "..") {
                    // IF ITEM IS A DIRECTORY
                    if (is_dir($DIR . $ITEM)) {
                        // CALL FUNCTION RECURSIVELY
                        $FILES += num_files($DIR . $ITEM);
                        // ELSE ITEM IS A FILE
                    } else {
                        $FILES+= 1;
                    }
                }
            }
            // CLOSE DIRECTORY
            closedir($DIR_ID);
        }
    }
    return $FILES;
}

function show_error($error, $extra = null)
{
    // show error-message
    show_header();
    echo "<div class=\"error\"><h2>".$GLOBALS["error_msg"]["error"]."</h2>\n";
    echo "<p>$error</p>\n";
    echo "<p><a HREF=\"javascript:window.history.back()\">";
    echo ">> ".$GLOBALS["error_msg"]["back"]."</a>";
    if ($extra!=null) {
        echo " - ".$extra;
    }
    echo "</p></div>\n";
    show_footer();
    exit;
}

function sessionLDAP()
{
    // Devuelve TRUE si se ha iniciado sesion contra LDAP. FALSE en caso contrario
    return $GLOBALS['usarldap'] && !empty($_SESSION['usuarioldap']) &&
           $_SESSION['usuarioldap'] != $GLOBALS["anonymous"];
}

function show_header()
{
    // header for html-page
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-cache, must-revalidate");
    header("Pragma: no-cache");
    header("Content-Type: text/html; charset=".$GLOBALS["charset"]);

    echo "<!DOCTYPE html>\n";
    echo "<html lang=\"".$GLOBALS["language"]."\" dir=\"".$GLOBALS["text_dir"]."\">\n";
    echo "<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".$GLOBALS["charset"]."\">\n";
    if (($GLOBALS["action"] == "") || ($GLOBALS["action"] == "list")) {
        echo "<meta http-equiv=\"Refresh\" content=\"600\">\n";
    }
    echo "<title>".$GLOBALS["messages"]["consignaservice"]."</title>\n";
    echo "<!--[if lte IE 8]>\n";
    echo "<script src=\"js/html5.js\"></script>\n";
    echo "<![endif]-->\n";
    require("includes/javascript.php");
    echo "<link href=\"css/consigna.css\" rel=\"stylesheet\" type=\"text/css\">\n";
    echo "</head>\n<body>\n";
    echo "<div class=\"bodymain\">\n";
    echo "<div id=\"contentbodymain\" class=\"container12\">\n";
    echo "<header>\n";
    echo "<div class=\"znmenusbasicos\">\n";

    echo "<nav class=\"menuidiomas\">\n<ul id=\"lang-selector\">";
    $last = count($GLOBALS["availablelanguages"]) - 1;
    $i=0;
    foreach ($GLOBALS["availablelanguages"] as $mylang => $value) {
        if ($i == 0) {
            $class="first ";
        } elseif ($i == $last) {
            $class="last ";
        } else {
            $class="";
        }
        $i++;
        if ($mylang == $GLOBALS["language"]) {
            $class.="selected";
        }
        echo "<li class=\"$class\" lang=\"$value\">\n";
        $uri=$_SERVER["REQUEST_URI"];
        $expreg="/lang=[a-z]*/";
        $newexpreg="lang=$mylang";
        if (preg_match($expreg, $uri)) {
            $new_uri=preg_replace($expreg, $newexpreg, $uri);
        } else {
            // No hay cadena de busqueda
            $new_uri=$_SERVER["PHP_SELF"]."?$newexpreg";
        }
        echo "<a href=\"$new_uri\">".$GLOBALS["messages"][$mylang]."</a></li>\n";
    }
    echo "</ul>\n</nav>\n";

    if ($GLOBALS['usarldap']) {
        echo "<div class=\"autenticacion\">\n";
        if (sessionLDAP()) {
            echo '<span class="usuarioldap">'.$_SESSION['nombreldap'];
            // Logout
            echo '<a href="'.make_link("logoutldap", "").'">';
            echo '<img src="images/_logout.gif" alt="salir" title="salir"/></a></span>';
        } else {
            echo "<form action=\"".make_link("autenticacionldap", "")."\" method=\"post\">\n";
            echo "<label for=\"usuario\">".$GLOBALS["messages"]["miscusername"].":</label>\n";
            echo "<input type=\"text\" name=\"usuario\" size=\"10\" maxlength=\"20\" value=\"\">\n";
            echo "<label for=\"contrasen\">".$GLOBALS["messages"]["miscpassword"].":</label>\n";
            echo "<input type=\"password\" name=\"contrasen\" size=\"10\" value=\"\">\n";
            echo "<input class=\"hacerlogin\" type=\"submit\" name=\"hacerlogin\" value=\"entrar\">\n";
            echo "</form>\n";
        }
    }
    echo "</div>\n</div>\n";
    echo "<div class=\"heading\">\n";
    echo " <a href=\"http://www.ehu.eus\" title=\"Abre en nueva ventana el sitio web ";
    echo "Universidad del País Vasco\" target=\"_blank\">\n";
    echo "<img src=\"images/logoehu.png\" width=\"234\" height=\"62\" alt=\"Universidad del ";
    echo "País Vasco Campus de excelencia internacional\"></a>\n";
    echo "<h1><span class=\"big\">".$GLOBALS["messages"]["consignaservice"]."</span></h1>\n";
    echo "</div>\n";
    echo "<div class=\"menugeneral\">\n";
    echo "<ul>\n<li class=\"first\"><a href=\"".$GLOBALS["messages"]["urlinfo"]."\">";
    echo $GLOBALS["messages"]["norm"]."</a></li>\n";
    echo "<li><a href=\"".$GLOBALS["messages"]["urlmanual"]."\">".$GLOBALS["messages"]["manual"]."</a></li>\n</ul>\n";
    echo "</div>\n</header>\n";

    echo "<div id=\"zn_buscador_ruta\" class=\"grid12\">\n";
    if (!sessionLDAP()) {
        echo "<div class=\"warning\">\n".$GLOBALS["messages"]["validatemessage"]."\n</div>\n";
    }
    echo "</div>\n";
}

function show_footer()
{
    echo "</div>\n</div>\n";
    echo "\n<footer class=\"footer\">\n";
    echo "<a class=\"title\" href=\"http://www.ehu.eus\" target=\"_blank\">";
    echo "Euskal Herriko Unibertsitatea / Universidad del Pa&iacute;s Vasco</a><br/>\n";
    echo "Modified  by <a href=\"http://www.ehu.eus\">Universidad del Pa&iacute;s Vasco</a> ";
    echo "and <a href=\"http://www.us.es\">Universidad de Sevilla</a> from ";
    echo "<a class=\"title\" href=\"http://quixplorer.sourceforge.net\">QuiXplorer</a>\n";
    echo "</footer>\n";
    echo "</body>\n</html>";
}

function scan_virus($item)
{
    if ($GLOBALS["antivirus"] != "") {
        $avcmd=sprintf($GLOBALS['antivirus'], $item);
        chmod($item, 0644);
        exec($avcmd, $output, $status);
        return $status;
    }
    return false;
}
