<?php
/*------------------------------------------------------------------------------
     The contents of this file are subject to the Mozilla Public License
     Version 1.1 (the "License"); you may not use this file except in
     compliance with the License. You may obtain a copy of the License at
     http://www.mozilla.org/MPL/

     Software distributed under the License is distributed on an "AS IS"
     basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
     License for the specific language governing rights and limitations
     under the License.

     The Original Code is fun_list.php, released on 2003-03-31.

     The Initial Developer of the Original Code is The QuiX project.

     Alternatively, the contents of this file may be used under the terms
     of the GNU General Public License Version 2 or later (the "GPL"), in
     which case the provisions of the GPL are applicable instead of
     those above. If you wish to allow use of your version of this file only
     under the terms of the GPL and not to allow others to use
     your version of this file under the MPL, indicate your decision by
     deleting  the provisions above and replace  them with the notice and
     other provisions required by the GPL.  If you do not delete
     the provisions above, a recipient may use your version of this file
     under either the MPL or the GPL."
------------------------------------------------------------------------------*/
/*------------------------------------------------------------------------------
Author: The QuiX project
    quix@free.fr
    http://www.quix.tk
    http://quixplorer.sourceforge.net

Comment:
    QuiXplorer Version 2.3
    Directory-Listing Functions
    
    Have Fun...
------------------------------------------------------------------------------*/
function getLabel($abs_item)
{
    $campos = array();
    $id=dba_open($GLOBALS["dbfile"], "r", "db4");
    if ($id > 0) {
        // Ahora hemos de comprobar si el password es vacio o no
        if (dba_exists($abs_item, $id)) {
            $dbline = dba_fetch($abs_item, $id);
            $campos = explode("/", $dbline);
        }
        dba_close($id);
    }
    return( substr($campos[2], 0, $GLOBALS["labellength"]));
}
//------------------------------------------------------------------------------
function make_tables($dir, &$file_list, &$tot_file_size, &$num_items)
{
    // make table of files in dir
    // make tables & place results in reference-variables passed to function
    // also 'return' total filesize & total number of items

    $tot_file_size = $num_items = 0;

    // Open directory
    $handle = @opendir(get_abs_dir($dir));
    if ($handle===false) {
        show_error($dir.": ".$GLOBALS["error_msg"]["opendir"]);
    }

    // Read directory
    while (($new_item = readdir($handle))!==false) {
        $abs_new_item = get_abs_item($dir, $new_item);
        if (!@file_exists($abs_new_item)) {
            show_error($dir.": ".$GLOBALS["error_msg"]["readdir"]);
        }
        if ($new_item == '.' || $new_item == '..') {
            continue;
        }
        $new_file_size = filesize($abs_new_item);
        $tot_file_size += $new_file_size;
        $num_items++;
        $order = $GLOBALS["order"];
        if ($order=="size") {
            $file_list[$new_item] = $new_file_size;
        } elseif ($order=="mod") {
            $file_list[$new_item] =
                @filemtime($abs_new_item);
        } elseif ($order=="type") {
            $file_list[$new_item] =
            get_mime_type($new_item, "type");
        } elseif ($order=="label") {
            $file_list[$new_item] = getLabel($abs_new_item);
        } else {
            // order == "name"
            $file_list[$new_item] = $new_item;
        }
    }
    closedir($handle);

    // sort
    if (is_array($file_list)) {
        if ($order=="mod") {
            if ($GLOBALS["srt"]=="yes") {
                arsort($file_list);
            } else {
                asort($file_list);
            }
        } elseif ($order=="size" || $order=="type" || $order=="label") {
            if ($GLOBALS["srt"]=="yes") {
                asort($file_list);
            } else {
                arsort($file_list);
            }
        } else {
            // order == "name"
            natcasesort($file_list);
            if ($GLOBALS["srt"]!="yes") {
                $file_list = array_reverse($file_list, true);
            }
        }
    }
}
//------------------------------------------------------------------------------
function print_table($dir, $list)
{
    // print table of files
    if (!is_array($list)) {
        return;
    }
    foreach ($list as $item => $value) {
        // link to dir / file
        $link = make_link("download", $dir, $item);
        echo "<tr class=\"rowdata\"><td><INPUT TYPE=\"checkbox\" name=\"selitems[]\" value=\"";
        echo $item."\" onclick=\"javascript:Toggle(this);\"></td>\n";
        echo "<td nowrap>";
        // Mostrar si el archivo esta protegido con password
        $id=dba_open($GLOBALS["dbfile"], "r", "db4");
        $con_password=0;
        if ($id > 0) {
            // Ahora hemos de comprobar si el password es vacio o no
            $abs_item=get_abs_item($dir, $item);
            if (dba_exists($abs_item, $id)) {
                $dbline=dba_fetch($abs_item, $id);
                $campos = explode("/", $dbline);
                $labelDBA=substr($campos[2], 0, $GLOBALS["labellength"]);
                if (($pos=strpos($dbline, "/")) && (strlen($dbline) > ($pos+1))) {
                    $con_password=1;
                }
            }
            dba_close($id);
        }
        // Icon + Link
        echo "<a HREF=\"".$link."\">";
        // Imagen que muestra si tiene permiso para descargar o no.
        if (tienePermiso($dir, $item)) {
            echo '<img src="images/unlock.png" alt="'.$GLOBALS["messages"]["conpermiso"].'" />';
        } else {
            echo '<img src="images/lock.png" alt="'.$GLOBALS["messages"]["sinpermiso"].'" />';
        }
        echo "<img width=\"16\" height=\"16\" ";
        echo "src=\"images/".get_mime_type($item, "img")."\" alt=\"".get_mime_type($dir, $item, "type")."\">&nbsp;";
        $s_item=$item;
        if (strlen($s_item)>50) {
            $s_item=substr($s_item, 0, 47)."...";
        }
        echo $s_item;
        echo "</a></td>\n";    // ...$extra...

       // Label
        echo "<td>".$labelDBA."</td>\n";
       // Size
        echo "<td>".parse_file_size(get_file_size($dir, $item))."</td>\n";
       // Type
        echo "<td>".get_mime_type($item, "type")."</td>\n";
        // Modified
        echo "<td>".parse_file_date(get_file_date($dir, $item))."</td>\n";
        echo "</tr>\n";
    }
}
//------------------------------------------------------------------------------
function show_toolbar()
{
    // Print the toolbar
    echo "<div class=\"toolbar\">\n<ul>\n";
    // RELOAD
    echo "<li><a HREF=\"javascript:location.reload();\"><img width=\"16\" height=\"16\" ";
    echo "src=\"images/_refresh.gif\" alt=\"".$GLOBALS["messages"]["reloadlink"];
    echo "\" title=\"".$GLOBALS["messages"]["reloadlink"]."\">".$GLOBALS["messages"]["reloadlink"]."</a></li>\n";
    // DELETE
    echo "<li><a HREF=\"javascript:Delete();\"><img width=\"16\" height=\"16\" ";
    echo "src=\"images/_delete.gif\" ALT=\"".$GLOBALS["messages"]["dellink"];
    echo "\" TITLE=\"".$GLOBALS["messages"]["dellink"]."\">".$GLOBALS["messages"]["dellink"]."</a></li>\n";
    // UPLOAD
    echo "<li><a HREF=\"".make_link("upload", "", null)."\">";
    echo "<img width=\"16\" height=\"16\" src=\"images/_upload.gif\" alt=\"".$GLOBALS["messages"]["uploadlink"];
    echo "\" TITLE=\"".$GLOBALS["messages"]["uploadlink"]."\">".$GLOBALS["messages"]["uploadlink"]."</a></li>\n";
    echo "</ul>\n</div>\n";
    // End Toolbar
}
//------------------------------------------------------------------------------
// MAIN FUNCTION
function list_dir($dir)
{
    // list directory contents

    // make file & dir tables, & get total filesize & number of items
    make_tables($dir, $file_list, $tot_file_size, $num_items);

    show_header();

    // Para poder mostrar si la descarga es autorizada o no
    include "./includes/fun_down.php";

    // Sorting of items
    $_img = "&nbsp;<img width=\"10\" height=\"10\" src=\"images/";
    if ($GLOBALS["srt"]=="yes") {
        $_srt = "no";
        $_img .= "_arrowup.gif\" ALT=\"".$GLOBALS["messages"]["asc"]."\" />";
    } else {
        $_srt = "yes";
        $_img .= "_arrowdown.gif\" ALT=\"".$GLOBALS["messages"]["desc"]."\" />";
    }

    echo "<div class=\"cuerpomensaje\">\n";

    show_toolbar();

    echo "<div id=\"listfiles\">\n";

    // Begin Table + Form for checkboxes
    echo "<FORM name=\"selform\" method=\"POST\" action=\"".make_link("post", $dir, null)."\">\n";
    echo "<INPUT type=\"hidden\" name=\"do_action\"><INPUT type=\"hidden\" name=\"first\" value=\"y\">\n";
    echo "<table class=\"listdir\" summary=\"".$GLOBALS["messages"]["listadoficheros"]."\">\n";
    echo "<caption>".$GLOBALS["messages"]["ficherosenconsigna"]."</caption>\n";
    // Table Header
    echo "<thead>\n";
    echo "<tr><th width=\"2%\" class=\"marked\">\n";
    echo "<INPUT TYPE=\"checkbox\" name=\"toggleAllC\" onclick=\"javascript:ToggleAll(this);\"></th>\n";
    echo "<th width=\"42%\" class=\"marked\">\n";
    $order = $GLOBALS["order"];
    if ($order=="name") {
        $new_srt = $_srt;
    } else {
        $new_srt = "yes";
    }
    echo "<a href=\"".make_link("list", $dir, null, "name", $new_srt)."\">".$GLOBALS["messages"]["nameheader"];
    if ($order=="name") {
        echo $_img;
    }
    echo "</a></th>\n<th width=\"10%\" class=\"marked\">";
    if ($order=="label") {
        $new_srt = $_srt;
    } else {
        $new_srt = "yes";
    }
    echo "<a href=\"".make_link("list", $dir, null, "label", $new_srt)."\">".$GLOBALS["messages"]["labelheader"];
    if ($order=="label") {
        echo $_img;
    }
    echo "</a></th>\n<th width=\"10%\" class=\"marked\">";
    if ($order=="size") {
        $new_srt = $_srt;
    } else {
        $new_srt = "yes";
    }
    echo "<a href=\"".make_link("list", $dir, null, "size", $new_srt)."\">".$GLOBALS["messages"]["sizeheader"];
    if ($order=="size") {
        echo $_img;
    }
    echo "</a></th>\n<th width=\"16%\" class=\"marked\">";
    if ($order=="type") {
        $new_srt = $_srt;
    } else {
        $new_srt = "yes";
    }
    echo "<a href=\"".make_link("list", $dir, null, "type", $new_srt)."\">".$GLOBALS["messages"]["typeheader"];
    if ($order=="type") {
        echo $_img;
    }
    echo "</a></th>\n<th width=\"14%\" class=\"marked\">";
    if ($order=="mod") {
        $new_srt = $_srt;
    } else {
        $new_srt = "yes";
    }
    echo "<a href=\"".make_link("list", $dir, null, "mod", $new_srt)."\">".$GLOBALS["messages"]["modifheader"];
    if ($order=="mod") {
        echo $_img;
    }
    echo "</a>\n</th>\n</tr>\n";
    echo "</thead>\n";

    // print number of items & total filesize
    echo "<tfoot>\n";
    echo "<tr>\n<td class=\"marked\"></td>";
    echo "<td class=\"marked\">".$num_items." ".$GLOBALS["messages"]["miscitems"]." (";
    $free = parse_file_size($GLOBALS["quota"]-$tot_file_size);
    echo $GLOBALS["messages"]["miscfree"].": ".$free.")</TD>\n";
    echo "<td class=\"marked\"></td>";
    echo "<td class=\"marked\">".parse_file_size($tot_file_size)."</td>\n";
    for ($i=0; $i<2; ++$i) {
        echo"<td class=\"marked\"></td>";
    }
    echo "</tr>\n";
    echo "</tfoot>\n";
    
    // make & print Table using lists
    print_table($dir, $file_list);

    echo "</table>\n";
    echo "</form>\n";
    echo "</div>\n";

    if ($num_items >= $GLOBALS["num_items_bottom_toolbar"]) {
        show_toolbar();
    }

    echo "</div>\n";
    
?><script type="text/javascript">
<!--
    // Uncheck all items (to avoid problems with new items)
    var ml = document.selform;
    var len = ml.elements.length;
    for(var i=0; i<len; ++i) {
        var e = ml.elements[i];
        if (e.name == "selitems[]" && e.checked == true) {
            e.checked=false;
        }
    }
// -->
</script><?php
}
